package org.jcon.df.edit.control.element;

import org.jcon.ui.ImageLib;
import org.jcon.util.TNode;

import javax.swing.Icon;

/**
* This class is an Element in a hierarchy, such as in
* a TreeControl. Its most important responsibility is to
* have a node, for use in a tree.
* <p>
* Set either the icon or the expandedIcon and collapsedIcon.
* The icon is used for lists, the others for trees.
* There is no default icon since usually one is not wanted.
* There are defaults for expandedicon and collapsedIcon.
*
* @author Jack Harich
*/
public class TreeElement extends Element {

//---------- Protected Fields ----------------------------
// Properties
protected TNode   node = new TNode();
protected boolean allowsChildren;

protected Icon    expandedIcon;  // null if use icon
protected Icon    collapsedIcon; // null if use icon

protected static Icon defaultExpandedIcon;
protected static Icon defaultCollapsedIcon;

//---------- Initialization ------------------------------
static {
try {
    // Set the default expanded and collapsed icons.
    // *** Mod later to correct files ***************
    // *** Currently these are both collapsed
    defaultExpandedIcon = ImageLib.loadClassResourceIcon(
        null, "ExpandedFolder.gif"); 
    
    defaultCollapsedIcon = ImageLib.loadClassResourceIcon(
        null, "CollapsedFolder.gif");
    
} catch(Exception ex) {
    ex.printStackTrace();
}
} // End method

//---------- Properties ----------------------------------
//----- Node
public void setNode(TNode node) {
    this.node = node;
}
public TNode getNode() {
    return node;
}
//----- AllowsChildren
public void setAllowsChildren(boolean allowsChildren) {
    this.allowsChildren = allowsChildren;
    node.setAllowsChildren(allowsChildren);
}
public boolean isAllowsChildren() {
    return allowsChildren;
}
//----- ExpandedIcon
public void setExpandedIcon(Icon expandedIcon) {
    this.expandedIcon = expandedIcon;
}
public boolean hasExpandedIcon() {
    return (expandedIcon != null ? true : false);
}
public Icon getExpandedIcon() {
    if (expandedIcon == null) {
        return icon;
    } else {
        return expandedIcon;
    }
}
//--- CollapsedIcon
public void setCollapsedIcon(Icon collapsedIcon) {
    this.collapsedIcon = collapsedIcon;
}
public boolean hasCollapsedIcon() {
    return (collapsedIcon != null ? true : false);
}
public Icon getCollapsedIcon() {
    if (collapsedIcon == null) {
        return icon;
    } else {
        return collapsedIcon;
    }
}    
//----- Default icons
public Icon getDefaultExpandedIcon() {
    return defaultExpandedIcon;
}
public Icon getDefaultCollapsedIcon() {
    return defaultCollapsedIcon;
}
//----- Other
public boolean isRoot() {
    return node.isRoot();
}
//---------- Public Methods ------------------------------
public void useDefaultIcons() {
    expandedIcon = defaultExpandedIcon;
    collapsedIcon = defaultCollapsedIcon;
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("TreeElement" + text);
}

} // End class
