package org.jcon.df.edit.control.element;

import java.util.Enumeration;
import java.util.Vector;


import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.DefaultMutableTreeNode;

/**
* This class is the standard model for the TreeControl.
* It has convenience methods for maintaining the tree
* contents, which must be Elements.
* <p>
* The following methods are normally used for collection
* access. We list them since some are in the superclass. 
* <p> <pre>
*    void insertElement(Element, boolean)
*    void removeElement(Object)
*    Enumeration getElements()
*
* @author Jack Harich, Joshua Marinacci
*/

public class ElementTreeModel extends DefaultTreeModel {

//---------- Superclass Overrides ------------------------
// (none yet, may assert that only Elements are added)
  private TreeElement rootElement;

  public TreeElement getRootElement() {
    return rootElement;
  }

  public ElementTreeModel(TreeElement root) {
    super(root.getNode());
    rootElement = root;
  }

  public ElementTreeModel() {
    this(new TreeElement());
  }


//---------- Properties ----------------------------------
  /*public int getElementCount() {
    return this.getSize();
    }*/
//---------- Public Methods ------------------------------
  /*
public Element getTheElementAt(int index) {
    return (Element)this.getElementAt(index);
    }*/

/**
* Inserts the element into the list of elements.
*
* @param element         the element to insert.
* @param alphabetically  if true then insert in alphabetical
*    order. If false insert as the last element.
*/
  /*
  public void insertElement(Element element, boolean alphabetically) {
    if (alphabetically) {
      insertAlphabetically(element);
    } else {
      this.addElement(element);
    }
  }
  */

/**
* Returns a Vector of all the UserObjects in the list, by
* getting the UserObject from each Element in the list.
*//*
public Vector getUserObjects() {
    Vector objects = new Vector();
    Enumeration enum = this.elements();
    while (enum.hasMoreElements()) {
        Element element = (Element)enum.nextElement();
        objects.addElement(element.getUserObject());
    //print(".getUserObjects() - Adding userObject " + element.getUserObject());        
    }
    return objects;
    }*/
/**
* A convenience method that inserts an Element with the
* text, alphabetically.
*//*
public void insertText(String text, boolean alphabetically) {
    Element element = new Element();
    element.setText(text);
    element.setUserObject(text);
    insertElement(element, alphabetically);
    }*/
//---------- Private Methods -----------------------------
/*
* Inserts the newElement before the first element whose
* text is "after" the newElement's text, or at the end if
* otherwise. Assumes the list is already in order.
*//*
private void insertAlphabetically(Element newElement) {
    String newText = newElement.getText();
    int size = this.getSize();
    
    for (int i = 0; i < size; i++) {
        Element element = (Element)this.getElementAt(i);
        if (newText.compareTo(element.getText()) < 0) {   
            this.insertElementAt(newElement, i);
            return; // <-----<<<
        }
    }
    // Empty or after all other elements
    this.addElement(newElement);
    }*/
//--- Std
private static void print(String text) {
    System.out.println("ElementListModel" + text);
}

} // End class
