package org.jcon.df.edit.control.element;

/**
* This class is a polymorphic event from a Control with
* Elements, such as a TreeControl or ListControl.
*
* @author Jack Harich
*/
public class ElementEvent {

//---------- Public Fields -------------------------------
/**
* Signifies the selection of elements has changed.
* The listener will usually call control.getSelectedElement()
* and proceed accordingly.
*/
public static final int SELECTION_CHANGED    = 1;

/**
* Indicates an element was "activated", which means
* it was double clicked or ENTER was pressed while the
* element was selected.
*/
public static final int ELEMENT_ACTIVATED   = 2;

//---------- Private Fields ------------------------------
// Properties
private int    eventType;
private String controlName;

//---------- Initialization ------------------------------
public ElementEvent(int eventType, String controlName) {
    this.eventType   = eventType;
    this.controlName = controlName;
}
//---------- Superclass Overrides ------------------------
public String toString() {
    return getEventTypeString();
}
//---------- Properties ----------------------------------
//----- eventType
public int getEventType() {
    return eventType;
}
public String getEventTypeString() {
    if (eventType == SELECTION_CHANGED) return "SelectionChanged";
    if (eventType == ELEMENT_ACTIVATED) return "ElementActivated";
    
    return "#UnknownType#";
}
public String getControlName() {
    return controlName;
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("ElementEvent" + text);
}

} // End class
