package org.jcon.df.edit.control.element;

import javax.swing.Icon;

/**
* This class is an "element" in a control, such as a
* line in a ListControl. It is designed to support displaying
* a visual line with an Icon and Text, and allow the
* business object to more easily manage the element by
* use of the ID and Type.
* <p>
* The ID should uniquely identify an element. The Type is
* for determining the logical type of an element, such as
* root versus level one versus level two. The use of ID
* and Type is very optional.
*
* @author Jack Harich
*/
public class Element {

//---------- Protected Fields ----------------------------
protected Icon      icon; 

protected Object    id;
protected Object    displayValue;
//private String    text;
//private String    type;
protected Object    userObject;

protected boolean   isBoldFont;
protected int       extraFontSize;
   
//---------- Superclass Overrides ------------------------
public String toString() {
  if(displayValue == null) {
    return "##NULL##";
  } else {
    return displayValue.toString();
  }
}
//---------- Properties ----------------------------------
//----- ID
/**
* Sets the items ID, which should be unique in the list.
* This may be an agreed upon between the GUI and the
* suppler. For example the ID could be "TCP" or "HTTP".
*/
public void setID(Object id) {
    this.id = id;
}
public Object getID() {
    return id;
}
/**
* Sets the value used for display. In the simplest case
* the value's toString() will be called.
*/
public void setDisplayValue(Object displayValue) {
    this.displayValue = displayValue;
}
public Object getDisplayValue() {
    return displayValue;
}
/**
* A convenience method that is the same as 
* setDisplayValue(Object). For backward compatability.
*/
public void setText(String text) {
    displayValue = text;
}
/**
* A convenience method that is the same as 
* getDisplayValue().toString(). For backward compatability.
*/
public String getText() {
    return displayValue.toString();
}
//----- Type
/* public void setType(String type) {
    this.type = type;
}
public String getType() {
    return type;
} */
//----- UserObject
public void setUserObject(Object userObject) {
    this.userObject = userObject;
}
public Object getUserObject() {
    return userObject;
}
//----- Icon
public void setIcon(Icon icon) {
    this.icon = icon;
}
public Icon getIcon() {
    return icon;
}
//----- isBoldFont
public void setBoldFont(boolean isBoldFont) {
    this.isBoldFont = isBoldFont;
}
public boolean isBoldFont() {
    return isBoldFont;
}
//----- extraFontSize
public void setExtraFontSize(int extraFontSize) {
    this.extraFontSize = extraFontSize;
}
public int getExtraFontSize() {
    return extraFontSize;
}
//----- Other
public boolean isCustomFont() {
    if (isBoldFont || extraFontSize != 0) {
        return true;
    } else {
        return false;
    }
    // Test shows always false approximately doubles
    // the speed of the response to expand or collapse.
    // So we need to optimize in the renderer to cache
    // components.
    //return false;
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("Element" + text);
}

} // End class
