package org.jcon.df.edit.control;

import org.jcon.util.DataLib;
import java.awt.Component;
import java.util.Vector;

import javax.swing.JTextPane;

/**
* A Control representing a JTextPane. 
* This is is designed for holding HTML.
* Default is not editable.
* 
* @author Joshua Marinacci, modffied by Jack Harich
*/
public class TextPaneControl extends Control {

//---------- Private Fields ------------------------------
private JTextPane pane = new JTextPane();

//---------- Abstract Implementation ---------------------
public Component getComponent() {
    return (Component)pane;
}  
//---------- Superclass Overrides ------------------------
public void init() {
    setEditable(false);
    pane.setContentType("text/html");
    
    // Added 1/31/99 JH - Not yet tested ***
    if (myParam.hasProperty("TextLines")) {
        Vector lines = myParam.getLinesVector("TextLines");
        String text = DataLib.convertVectorToDelimString(lines, "\n");
        pane.setText(text);
    } else {
        // *** Comment out for production
        pane.setText("<b>hi</b> <h1> yo </h1>");
    }
}
public void setEditable(boolean editable) {
    pane.setEditable(editable);
}
public void setValue(Object value) {
    if(value instanceof String) {
        String text = (String) value;
        text = "<html><body>"+text+"</body></html>";
        //      print(".setText("+text+")");
        //     print("pane = " + pane);
        //      print("valid = " + pane.isValid());
        if (pane.isValid() != true) {
            pane.validate();
        }
        pane.setText(text);
    } else {
        throw new IllegalArgumentException("The " +
        "TextPaneControl.setValue(Object) method only accepts String arguments.");
    }
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("TextPaneControl" + text);
}

} // End class
