package org.jcon.df.edit.control;

import org.jcon.param.Param;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTextArea;

/**
* A Control representing a TextArea
*
* @author Joshua Marinacci, Jack Harich
*/
public class TextAreaControl extends Control {

//---------- Private Fields ------------------------------
private JTextArea     textArea = new JTextArea();
private boolean       isEditable;

//---------- Abstract Implementation ---------------------
public Component getComponent() {
    return (Component)textArea;
}
//---------- Superclass Overrides ------------------------
public void init() { // Called after above

    if (myParam.hasProperty("Text")) {
        setValue(myParam.getString("Text"));
    }
    //    if (myParam.hasProperty("Columns")) {
    //        textArea.setColumns(myParam.getInt("Columns"));
    //    }
    // null, "true" or "false"
    
    textArea.setEditable(myParam.isTrueDefaultTrue("Editable"));
    if (! textArea.isEditable()) {
        textArea.setBackground(Color.lightGray);
    }
}
public void setEditable(boolean editable) {
    isEditable = editable;
    textArea.setEditable(isEditable);
}
public void setValue(Object value) {
    if (value == null) value = "";
    //print(".setValue() ------ before " + value);
    textArea.setText(value.toString());
    //print(".setValue() ------ after " + value);
}
// Note trim. Perhaps we should only right trim. ***
public Object getValue() {
    // return textArea.getText().trim();
    return textArea.getText();
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("TextAreaControl" + text);
}

} // End class
