package org.jcon.df.edit.control;

import org.jcon.ui.VisualLib;
import org.jcon.param.Param;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;

/**
* A Control for putting a "space" somewhere for fine 
* tuning the arrangement of Components. This is done by
* setting the preferred "Size" property, which has a
* default of 0, 0.
*
* @author Jack Harich
*/
public class SpacerControl extends Control {

//---------- Private Fields ------------------------------
private Spacer spacer = new Spacer();

//---------- Abstract Implementation ---------------------
public Component getComponent() {
    return (Component)spacer;
}
//---------- Superclass Overrides ------------------------
public void init() {
    String line = myParam.getString("Size");
    if (line != null) {
        Dimension dim = VisualLib.parseDimension(line);
        spacer.setPreferredSize(dim);
    }
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("SpacerControl" + text);
}
//========== Inner Classes ===============================
// Corrected my feeble first pass - JH
private class Spacer extends JComponent {

//private Dimension preferredSize = new Dimension(0, 0);

public Spacer() {
    setMinimumSize(new Dimension(0, 0));
}
//---------- Superclass Overrides ------------------------
/*public Dimension getPreferredSize() {
    return preferredSize;
}
public Dimension getMinimumSize() {
    return new Dimension(0, 0);
}
//---------- Properties ----------------------------------
public void setPreferredSize(Dimension size) {
    preferredSize = size;
} */

} // End inner class

} // End outer class
