package org.jcon.df.edit.control;

import org.jcon.param.Param;
import org.jcon.util.DataLib;
import java.awt.Color;
import java.awt.Component;
import java.awt.TextArea;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

/**
 * A Control representing a large String.
 * *** DUPECODE, need to normalize ***
 *
 * @author Jack Harich
 */
public class MemoControl extends Control
    implements TextListener, FocusListener {

//---------- Private Fields ------------------------------
private TextArea     textField = new TextArea
    ("", 3, 50, TextArea.SCROLLBARS_VERTICAL_ONLY);
private boolean      isEditable;

//---------- Initialization ------------------------------
//public MemoControl() {
//}
//---------- Abstract Implementation ---------------------
public Component getComponent() {
    return (Component)textField;
}
//---------- Superclass Overrides ------------------------
public void init() { // Called after above
    textField.addTextListener(this);
    textField.addFocusListener(this);

    if (myParam.hasProperty("Text")) {
        textField.setText(myParam.getString("Text"));
    }
    if (myParam.hasProperty("Rows")) {
        textField.setColumns(myParam.getInt("Rows"));
    }
    if (myParam.hasProperty("Columns")) {
        textField.setColumns(myParam.getInt("Columns"));
    }
}
public void setEditable(boolean editable) {
    isEditable = editable;
    textField.setEditable(isEditable);
    refreshBackgroundColor();
}
public void setValue(Object value) {
    if (value == null) value = "";
    //print(".setValue() ------ before " + value);
    textField.setText(value.toString());
    //print(".setValue() ------ after " + value);
}
// Note trim. Perhaps we should only right trim. ***
public Object getValue() {
    return textField.getText().trim();
}
//---------- TextListener Implementation -----------------
public void textValueChanged(TextEvent evt) {
    checkIllegalCharacters();
    checkAutoUpperCase();
    refreshBackgroundColor();
}
//---------- FocusListener Implementation ----------------
public void focusGained(FocusEvent evt) {
}
public void focusLost(FocusEvent evt) {
    if (columnDef == null) return;

    if (columnDef.getType().equals("Date")) {
        // Automatically add "19" or "00" if /YY
        String text = textField.getText().trim();
        if (text.length() < 6) return;

        int lastSlash = text.lastIndexOf("/");
        //print(" lastSlash = " + lastSlash);
        if (lastSlash < 0) return;

        String yy = text.substring(lastSlash + 1);
        if (yy.length() > 2) return;
        //print(" yy = " + yy);
        if (! DataLib.isInt(yy)) return;

        int year = Integer.parseInt(yy);
        String century = (year < 50 ? "20" : "19");

        String prefix = text.substring(0, lastSlash);
        String newText = prefix + "/" + century + yy;

        textField.setText(newText);
    }
}
//---------- Private Methods -----------------------------
private void checkAutoUpperCase() {
    boolean autoUpperCase = columnDef.isUpperCase();
    String text = textField.getText().trim();
    if (autoUpperCase == true && ! text.equals(text.toUpperCase())) {
        // Must save and restore caret position for usability
        int caretPosition = textField.getCaretPosition();
        textField.setText(text.toUpperCase());
        textField.setCaretPosition(caretPosition);
    }
}
private void checkIllegalCharacters() {
    String text = textField.getText().trim();
    //----- Remove all single quotes since they cause
    //      errors in SQL statements
    if (text.indexOf("'") > -1) {
        text = DataLib.removeCharacter(text, '\'');
        // Must save and restore caret position for usability
        int caretPosition = textField.getCaretPosition();
        textField.setText(text);
        textField.setCaretPosition(caretPosition - 1); // -1 since char removed
    }
}
private void refreshBackgroundColor() {
    Color color;
    boolean isEmpty = (textField.getText().trim().equals(""));
    // *** print(" isEmpty = " + isEmpty);
    if (! isEditable) {
        color = Color.lightGray;
    } else if (columnDef.isRequired() && isEmpty) {
        color = Color.yellow;
    } else {
        color = Color.white;
    }
    if (! textField.getBackground().equals(color)) {
        textField.setBackground(color);
    }
}
//--- Std
private static void print(String text) {
    System.out.println("MemoControl" + text);
}

} // End class
