package org.jcon.df.edit.control;

import org.jcon.ui.MultiLineLabel;
import org.jcon.ui.VisualLib;
import org.jcon.param.Param;
import java.awt.Component;

import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;

/**
 * A Control representing a single line Label.
 *
 * @author Jack Harich
 */
public class LabelControl extends Control {

//---------- Private Fields ------------------------------
private JLabel label = new JLabel();
//private MultiLineLabel label = new MultiLineLabel();

//---------- Initialization ------------------------------
public LabelControl(String text) {
    this();
    label.setText(text);
}
public LabelControl() {
    // The result was all zeros
    //print(" - JLabel insets = " + label.getInsets());
    
    // We only want extra padding on left and right, default is none
    // (top, left, bottom, right)
    label.setBorder(new EmptyBorder(0, 4, 0, 4));
}
//---------- Abstract Implementation ---------------------
public Component getComponent() {
    return (Component)label;
}
//---------- Superclass Overrides ------------------------
public void init() {
    label.setText(myParam.getString("Text"));
    if (myParam.hasProperty("FontProperties")) {
        Param param = myParam.getParam("FontProperties");
        if (param.isTrueDefaultFalse("Bold")) {
            label.setFont(VisualLib.createBoldFont(label, true));
        }
        int extraPointSize = param.getIntDefaultZero("ExtraPointSize");
        if (extraPointSize != 0) {
            label.setFont(VisualLib.createLargerFont(label, extraPointSize));
        }                
    }
}
public void setValue(Object value) {
    if (value == null) value = "";
    label.setText(value.toString());
}
public Object getValue() {
    return label.getText();
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("LabelControl" + text);
}

} // End class
