package org.jcon.df.edit.control;

import org.jcon.df.edit.EditEvent;
import org.jcon.df.edit.control.util.ValueSelection;
import org.jcon.ui.ImageLib;
import org.jcon.param.Param;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import java.util.Locale;
import java.text.Collator;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;

/**
 * A Control representing a JComboBox;
 *
 * @author Joshua Marinacci
 * note: adapted from code by @author Jack Harich
 */
public class JComboBoxControl extends Control
    implements ActionListener {

//---------- Private Fields ------------------------------
private JComboBox    combo = new JComboBox();
private boolean    isEditable;
private String     actionCommand;

//---------- Initialization ------------------------------
public JComboBoxControl() {
    combo.addActionListener(this);
}
//---------- Abstract Implementation ---------------------
public Component getComponent() {
    return (Component)combo;
}
//---------- Superclass Overrides ------------------------
  public void init() { // Called after above
    
    // get the list and add it to the combo
    Param contents = myParam.getParam("Contents");
    if(contents != null) {
      String[] keys = contents.getDataKeys();
      for(int i=0; i<keys.length; i++) {
      insertAlphabetically(contents.get(keys[i]));
      }
    }
    
    
    // get the command
    actionCommand = myParam.getString("Command");
    
    // This will be no tool tip text if not supplied
    combo.setToolTipText(myParam.getString("ToolTipText"));
    
    // For uniform width buttons in button bar
    if (myParam.hasProperty("PreferredWidth")) {
      int prefWidth = myParam.getInt("PreferredWidth");
      int prefHeight = combo.getPreferredSize().height;
      combo.setPreferredSize(new Dimension(prefWidth, prefHeight));
    }
  }
  public void setEditable(boolean editable) {
    // Not supported
  }
  public void setValue(Object value) {
    print(".setValue() value = " + value);
    ValueSelection vs = (ValueSelection)value;
    print(" selected set to : " + vs.getSelectedValue());
    
    Vector v = (Vector)vs.getList();
    combo.removeAllItems();
    for(int i=0; i<v.size(); i++) {
	  insertAlphabetically(v.elementAt(i));
      //print(" list = " + v.elementAt(i));
    }
    
    print(" index = " + vs.getSelectedIndex());
    combo.setSelectedIndex(vs.getSelectedIndex());
  }
  public Object getValue() {
    Vector v = new Vector();
    for(int i=0; i<combo.getItemCount(); i++) {
      v.addElement(combo.getItemAt(i));
    }
    
    ValueSelection sv = new ValueSelection();
    sv.setList(v);
    sv.setSelectedValue((String)combo.getSelectedItem());

    print(" returning: " + sv);

    return sv;
    //    return combo.getSelectedItem();
  }
  public void actionPerformed(ActionEvent evt) {
    if (actionCommand != null && editListener != null) {
      // Fire event
      EditEvent editEvent = new EditEvent
	(EditEvent.COMMAND, null); // null for no DataSourceID
      editEvent.setCommand(actionCommand);
      editListener.processEditEvent(editEvent);       
    }
  }
  //--- Std
  private static void print(String text) {
    System.out.println("JComboBoxControl" + text);
  }

/**
* Inserts a String element into the ComboBox alphabetically in a Locale
* specific manner.
*  
* @author C. Conway
*/
  private void insertAlphabetically(Object newObject) {
     int size = combo.getItemCount(); 
     String listItem; // used for each item in the combo box
	 String newItem = (String)newObject; // the item to add

     // CMC - Replace this line when Jack gets LocaleMgr done.
	 //----------------------------------------------------------
	 // Get the Locale specific Collator.
	 //----------------------------------------------------------
     Collator collator = Collator.getInstance(Locale.getDefault());
     //Collator collator = Collator.getInstance(Locale.JAPAN);

	 //----------------------------------------------------------
     // Compare the new Item to each in the combo box.
	 // if newItem is less than the current list item, insert
	 // newItem before the list item
	 //----------------------------------------------------------
     for (int i = 0; i < size; i++) {
        listItem = (String)combo.getItemAt(i);

        if (collator.compare(newItem, listItem) < 0) {
           combo.insertItemAt(newItem, i);
           return;
        }
	 }

	 //----------------------------------------------------------
	 // Put it at the end.
	 //----------------------------------------------------------
     combo.addItem(newItem);
  }
  
} // End class
