package org.jcon.df.edit.control;

import org.jcon.param.Param;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

/**
* This class is a visual Information Panel, similar to a
* Status Bar. It presents infomation, which is usually text.
* It also can present an icon, which is used to cue the 
* user to the type of info being shown.
* <p>
* Future features could be HTML support, Okay button,
* dynamic size, etc.
*
* @author Jack Harich
*/
public class InfoPaneControl extends Control {

//---------- Private Fields ------------------------------
// Internal
private JTextArea     textArea = new JTextArea();
private JPanel        panel = new JPanel();
private Icon          previousIcon; // null if none

//---------- Abstract Implementation ---------------------
public Component getComponent() {
    return (Component)panel;
}
//---------- Superclass Overrides ------------------------
public void init() { // Called after above
    // Prepare textArea in panel
    panel.setLayout(new BorderLayout());
    panel.add(textArea, "Center");
    textArea.setEditable(false);
    textArea.setBackground(Color.lightGray);
    textArea.setBorder(new EmptyBorder(2, 5, 2, 5)); // Top, left, bottom, right
    textArea.setLineWrap(true); // Should be the default
    textArea.setWrapStyleWord(true);
    
    // Set font to avoid default font of Monospaced 12
    // We simply match the default JTextField font
    textArea.setFont(new JTextField().getFont());
    
    //print(".init() - textArea font = " + textArea.getFont());

    // The initial text shown, usually none
    if (myParam.hasProperty("InitialText")) {
        setValue(myParam.getString("InitialText"));
    }   
}
public void setValue(Object value) {
    if (value == null) value = "";
    //print(".setValue() ------ before " + value);
    textArea.setText(value.toString());
    //print(".setValue() ------ after " + value);
}
public Object getValue() {
    return textArea.getText();
}
//---------- Properties ----------------------------------
/**
* Sets the icon to be shown to the left of the text.
* If icon is null then no icon will be shown. (*** TEST)
*/
public void setIcon(Icon icon) {
    if (icon == null) {
        if (previousIcon != null) {
            panel.remove((Component)previousIcon);
        }
    } else {
        panel.add((Component)icon, "West");
    }
    previousIcon = icon;
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("InfoPaneControl" + text);
}

} // End class
