package org.jcon.df.edit.control;

import org.jcon.ui.JImageCanvas;
import java.awt.Component;

/**
 * A Control representing an Image.
 *
 * @author Jack Harich
 */
public class ImageControl extends Control {

//---------- Private Fields ------------------------------
private JImageCanvas imageCanvas;

//---------- Abstract Implementation ---------------------
public Component getComponent() {
    return (Component)imageCanvas;
}
//---------- Superclass Overrides ------------------------
public void init() {
    String resourceClass = myParam.getString("ResourceClass");
    String resourceName = myParam.getString("ResourceName");
    //print(".init() - " + resourceClass + ", " + resourceName);
    
    imageCanvas = new JImageCanvas(resourceClass, resourceName);
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("ImageControl" + text);
}

} // End class
