package org.jcon.df.edit.control;

import org.jcon.df.edit.EditEvent;
import org.jcon.param.Param;
import org.jcon.ui.ImageLib;
import org.jcon.ui.VisualLib;
import org.jcon.ui.easylayout.EasyLayout;
import org.jcon.ui.easylayout.EasyLayoutLibrary;
import org.jcon.ui.easylayout.EasyLayoutLibraryStd;
import org.jcon.ui.comp.DoClickable;
import org.jcon.ui.comp.Hyperlink;
import org.jcon.util.msg.Message;
import org.jcon.param.Param;
import org.jcon.param.StringVector;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;

/**
* A Control looking like a hyperlink. It has associated
* Text, Icon, InfoText and Command.
*
* @author  Jack Harich 
*/  
public class HyperlinkControl extends Control
    implements ActionListener, DoClickable {

//---------- Private Fields ------------------------------
// Internal
private Hyperlink hyperlink = new Hyperlink();

// This wierd flag avoids firing the unwanted MouseExited
// event that occurs when clicking on a link. If this is
// fired it overwrites the proper InfoText with the text
// from the unwanted MouseExited link text.
private boolean   isIgnoreNextMouseExitedEvent;

//---------- Abstract Implementation ---------------------
public Component getComponent() {
    return (Component)hyperlink;
}
//---------- Superclass Overrides ------------------------
public void init() { // Called after above
    hyperlink.setActionListener(this);
    hyperlink.setText(" " + myParam.getString("Text")); // To separate icon and text
    hyperlink.setCommand(myParam.getString("Command"));
    hyperlink.setInfoText(myParam.getLinesVectorString("InfoText", " "));
    
    // linkIcon. There may be redundency in the Params.
    String className = myParam.getString("IconMarker");
    String resourceName = myParam.getString("IconResourceName");
    if (className != null) {
        Image image = ImageLib.loadClassResourceImage(
            className, resourceName);    
        hyperlink.setIcon(new ImageIcon(image));
    }
}
//---------- ActionListener Implementatons ---------------
public void actionPerformed(ActionEvent evt) {
    if (editListener == null) {
        print(".actionPerformed() - No editListener");
        return;
    }
    Hyperlink link = (Hyperlink)evt.getSource();
    String option = evt.getActionCommand().intern();
    
    if (option == "Command") {
        String command = link.getCommand().intern();
        //print(".actionPerformed() - Command = " + command);
        //print(" - InfoText: \n" + link.getInfoText());
        
        if (command != null) {
            // Fire event
            isIgnoreNextMouseExitedEvent = true;
            EditEvent editEvent = new EditEvent(
                EditEvent.COMMAND, null); // null for no DataSourceID
            editEvent.setCommand(command);
            editListener.processEditEvent(editEvent);       
        } 
    } else if (option == "MouseEntered") {
        fireShowInfoTextEvent(link, option);              
    
    } else if (option == "MouseExited") {
        if (isIgnoreNextMouseExitedEvent) {
            isIgnoreNextMouseExitedEvent = false;
        } else {
            fireShowInfoTextEvent(link, option);    
        }
    } 
}
//---------- DoClickable Implementation ------------------
public void doClick(int pressTime) {
    hyperlink.doClick(pressTime);
}
//---------- Private Methods -----------------------------
private void fireShowInfoTextEvent(Hyperlink link, String option) {
    //print(".fireShowInfoTextEvent() - Firing option " + option);
    EditEvent editEvent = new EditEvent(
        EditEvent.MESSAGE, null); // null for no DataSourceID
    Message message = new Message("EditEvent");
    message.set("EventType", "CommandParam");
    
    // Set text
    String text = null;
    if (option == "MouseEntered") {
        text = link.getInfoText();
    } else if (option == "MouseExited" || option == null) {
        text = null; 
    }   
    // Create command Param, put in message
    StringVector lines = new StringVector();
    if (text != null) lines.addElement(text);
    
    Param cmdParam = new Param();
    cmdParam.put("CommandName", "SetInfoText");
    if (! lines.isEmpty()) cmdParam.put("InfoText", lines);
    message.set("Param", cmdParam);

    // Send message
    editEvent.setMessage(message);
    editListener.processEditEvent(editEvent); 
}
//--- Std
private static void print(String text) {
    System.out.println("HyperlinkControl" + text);
}

} // End class
