package org.jcon.df.edit.control;

import org.jcon.df.edit.EditEvent;
import java.awt.Component;
import java.awt.Color;
import java.awt.BorderLayout;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

/**
* A Control representing a JEditorPane. Not editable.
* This is is designed for holding HTML. It fires a
* EditEvent.HYPERLINK_ACTIVATED when a hyperlink is
*"activated".
* 
* @author Jack Harich
*/
public class EditorPaneControl extends Control
    implements HyperlinkListener {

//---------- Private Fields ------------------------------
private JPanel panel = new JPanel();

//---------- Abstract Implementation ---------------------
public Component getComponent() {
    return (Component)panel;
}  
//---------- Superclass Overrides ------------------------
public void init() { 
    String url = myParam.getString("URL");
    if (url == null) throw new IllegalStateException(
            "Missing URL in EditorPaneControl for Param " + myParam);
    initPanel(url);
}
public void setEditable(boolean editable) {
    print(".setEditable() - Not supported, is only not editable.");
}
/**
* Refreshes the page using the URL in the value.
*/
public void setValue(Object value) {
    if(value instanceof String) {
        initPanel((String)value);
    } else {
        throw new IllegalArgumentException("The " +
            "EditorPaneControl.setValue(Object) method only accepts String arguments.");
    }
}
//---------- HyperlinkListener Implementation ------------
public void hyperlinkUpdate(HyperlinkEvent evt) {
    if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
        String url = evt.getURL().toString();
        // Fire event
        if (editListener != null) {
            EditEvent editEvent = new EditEvent(
                EditEvent.HYPERLINK_ACTIVATED, null); // null for no DataSourceID
            editEvent.setHyperlink(url);
            editListener.processEditEvent(editEvent);  
            print(".hyperlinkUpdate() - Fired event for link '" + url + "'");
        }        
    }
}
//---------- Private Methods -----------------------------
private void initPanel(String url) {
    try {
        JEditorPane pane = new JEditorPane();
        pane.setPage(url);
        pane.addHyperlinkListener(this);
        pane.setEditable(false);
        // ****** A test. It worked, was white before
        // event thought the HTML was gray. It appears that
        // even in Swing 1.1.1B3 we must setBackground
        // unless we want white.
        pane.setBackground(Color.lightGray);
   
        // *** Causes window resize problems, extra border
        /*JScrollPane scroller = new JScrollPane();
        //scroller.setBorder(swing.loweredBorder);
        
        JViewport viewPort = scroller.getViewport();
        viewPort.add(pane);
        viewPort.setBackingStoreEnabled(true);
        
        panel.add(scroller, BorderLayout.CENTER); */
        
        // *** This works, but no scroller
        panel.setLayout(new BorderLayout());
        panel.add("Center", pane);
        
    } catch (MalformedURLException ex) {
        print(".init() - Malformed URL using '" + url + "'.");
        ex.printStackTrace();
        
    } catch (IOException ex) {
        print("IOException using URL '" + url + "'.");
        ex.printStackTrace();
    }    
}
//--- Std
private static void print(String text) {
    System.out.println("EditorPaneControl" + text);
}

} // End class
