package org.jcon.df.edit.control;

import java.awt.event.ActionListener;

/**
* This interface represents a Button, JButton or other
* Component that emits ActionEvents. We use the class name
* ControlAction rather than the more logical "ActionControl"
* to get the package infrastructure to sort together.
*
* @author Jack Harich 
*/

public interface ControlAction {

// We have encapsulated the ActionEvent into EditEvent

/**
* Adds the listener for ActionEvents.
*/
/** public void addActionListener(ActionListener listener);

/**
* Removes the listener for ActionEvents.
*/
/** public void removeActionListener(ActionListener listener);

/**
* Requests the control to simulate a user click. This is for
* testing. The result will be an ActionEvent sent to
* registered listeners.
*/
public void doClick();


} // End interface
