package org.jcon.df.edit.control;

import org.jcon.df.edit.EditEvent;
import org.jcon.param.Param;
import java.awt.Component;
import java.awt.Button;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

// Use Button instead of JButton due to Swing bugs 9/17/98 JH
// - Cannot enter text in JTextField at first
// - JPasswordField width is always zero
// - If TextField and JButton then tab never moves
//      focus to JButton

/**
 * A Control representing a Button.
 *
 * @author Jack Harich
 */
public class ButtonControl extends Control
    implements ActionListener {

//---------- Private Fields ------------------------------
private Button    button = new Button();
private boolean    isEditable;
private String     actionCommand;

//---------- Initialization ------------------------------
public ButtonControl() {
    button.addActionListener(this);
}
//---------- Abstract Implementation ---------------------
public Component getComponent() {
    return (Component)button;
}
//---------- Superclass Overrides ------------------------
public void init() { // Called after above
    button.setLabel(myParam.getString("Text"));
    actionCommand = myParam.getString("Command");
}
public void setEditable(boolean editable) {
    // Not supported
}
public void setValue(Object value) {
    // Not supported 
}
public Object getValue() {
    return null; // Not supported
}
//---------- ActionListener Implementation ---------------
public void actionPerformed(ActionEvent evt) {
    if (actionCommand != null && editListener != null) {
        // Fire event
        EditEvent editEvent = new EditEvent(
            EditEvent.COMMAND, null); // null for no DataSourceID
        editEvent.setCommand(actionCommand);
        editListener.processEditEvent(editEvent);       
    }
}
//--- Std
private static void print(String text) {
    System.out.println("ButtonControl" + text);
}

} // End class
