package org.jcon.df.edit.control;

import org.jcon.df.edit.EditEvent;
import org.jcon.df.edit.EditListener;
import org.jcon.param.Param;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Hashtable;
import java.util.Vector;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.border.EmptyBorder;

/**
 * A very configurable Control containing a row of buttons.
 * We use a Control instead of a Module because no more
 * widgets can be added in the Param. This class is
 * expected to change as new requirement emerge.
 *     *** Add border ability later ***
 *
 * @author Jack Harich
 */
public class ButtonBarControl extends Control {

//---------- Private Fields ------------------------------
// Internal
private JPanel mainPanel = new JPanel();

// Key = name, Object = JButton
private Hashtable buttons = new Hashtable();

//---------- Initialization ------------------------------
public ButtonBarControl() {
    // Pack buttons together for good bar appearance
    mainPanel.setLayout(new BoxLayout(mainPanel, BoxLayout.X_AXIS));
    //mainPanel.setBackground(java.awt.Color.green); // ******** TEST
}
//---------- Abstract Implementation ---------------------
public Component getComponent() {
    return (Component)mainPanel;
}
//---------- Superclass Overrides ------------------------
public void init() { 
    mainPanel.removeAll();
    buttons.clear();
    boolean isGap = false;
    Param buttonsParam = myParam.getParam("Buttons");
    String[] names = buttonsParam.getDataKeys();
    
    // Add 1 pixel around for proper illusion
    mainPanel.setBorder(new EmptyBorder(1, 1, 1, 1));
    for (int i = 0; i < names.length; i++) {
        String name = names[i];
        Param param = (Param)buttonsParam.getParam(name);
        String type = param.getStringDefault("Type", "Button").intern();
        
        if (type == "Button") {
            addButton(name, param);
            
        } else if (type == "Spring") {
            addSpring(param);
            
        } else {
            print(".init() - Unknown Type '" + type + "'");
            break;
        }
    }
}
//---------- Public Methods ------------------------------
/**
* Enables or disables the named button.
*/
public void setEnabled(String name, boolean isEnabled) {
    JButton button = getButton(name);
    if (button != null) button.setEnabled(isEnabled);
}
/**
* Requests the focus on the named button.
*/ 
public void requestFocus(String name) {
    JButton button = getButton(name);
    if (button != null) button.requestFocus();
}
//---------- Private Methods -----------------------------
private JButton getButton(String name) {
    JButton button = (JButton)buttons.get(name);
    if (button == null) {
        throw new IllegalArgumentException("Cannot find button named '" + name + "'.");
    } else {
        return button;
    }
}
private void addButton(String name, Param param) {
    JButtonControl control = new JButtonControl();
    control.setEditListener(this.editListener);  // Forward events to my listener
    control.setParam(param);
    control.init();
    
    JButton button = (JButton)control.getComponent();
    mainPanel.add(button);
    buttons.put(name, button);
}
private void addSpring(Param param) {
    // This is misnamed in Swing. It is NOT a logical glue
    // since glue holds things together. It's a spring.
    mainPanel.add(Box.createHorizontalGlue());
}
//--- Std
private static void print(String text) {
    System.out.println("ButtonBarControl" + text);
}

} // End class
