package org.jcon.df.edit.control;

import org.jcon.df.edit.EditEvent;
import org.jcon.param.Param;
import org.jcon.util.DataLib;
import java.awt.Color;
import java.awt.Component;
//import java.awt.Checkbox;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;

/**
 * A Control representing a Boolean. A Checkbox is used.
 *
 * @author Jack Harich
 */
public class BooleanControl extends Control 
    implements ItemListener {

//---------- Private Fields ------------------------------
//private Checkbox     checkbox = new Checkbox();
private JToggleButton widget;
private boolean       isEditable;

//---------- Abstract Implementation ---------------------
public Component getComponent() {
    return (Component)widget;
}
//---------- Superclass Overrides ------------------------
public void init() { // Called after above
    boolean isOptionButton =
         myParam.isTrueDefaultFalse("IsOptionButton");
         
    if (isOptionButton) {
        widget = new JRadioButton();
    } else {
        widget = new JCheckBox();
    }
    widget.addItemListener(this);
}
public void setEditable(boolean editable) {
    isEditable = editable;
    // Bkg color not settable
    widget.setEnabled(isEditable);
}
public void setValue(Object value) {
    if (value == null) value = "0";
    //        print("value = " + value.getClass());
	//        print(".setValue() ------ before " + value);

    // joshy
    if(value instanceof Boolean) {
      Boolean v = (Boolean)value;
      //      print("value = " + v);
      //      print("booleanValue = " + v.booleanValue());
      widget.setSelected(v.booleanValue());
      //      print(" now value = " + widget.isSelected());
      print(" now value = " + getValue());
      return;
    }
    // end joshy

    if (value.equals("1") || value.equals("true")) {
        widget.setSelected(true);

    } else if (value.equals("0") || value.equals("false")) {
        widget.setSelected(false);

    } else {
        throw new IllegalArgumentException("Boolean value "
            + "must be 1 or 0, not '" + value + "'.");
    }
    //print(".setValue() ------ after " + value);
}
// Return 1 or 0 for true or false
public Object getValue() {
    //print(".getValue() - " + widget.isSelected());
    return (widget.isSelected() == true ? "1" : "0");
}
//---------- ItemListener Implementation -----------------
public void itemStateChanged(ItemEvent evt) {
    if (editListener != null) {
        // Fire event
        EditEvent editEvent = new EditEvent(
            EditEvent.TOGGLE_STATE_CHANGED, null); // null for no DataSourceID
        editEvent.setWorkerName(name);
        editEvent.setSelected(widget.isSelected());
        editListener.processEditEvent(editEvent);
    }
}
//---------- Properties ----------------------------------
//----- isSelected
public void setSelected(boolean isSelected) {
    // Now done by WidgetSet
    //if (! widget.isSelected()) { // Avoid flicker
        widget.setSelected(isSelected);
    //}
}
public boolean isSelected() {
    return widget.isSelected();
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("BooleanControl" + text);
}

} // End class
