package org.jcon.df.edit;

import org.jcon.df.edit.DataView;
import org.jcon.df.edit.control.*;
import org.jcon.df.edit.module.*;
//import org.jcon.df.request.DataRequestDef;
//import org.jcon.df.work.DataSource;
import org.jcon.ui.OutputConsole;
import org.jcon.util.BenchMark;
import org.jcon.ui.easylayout.EasyLayout;
import org.jcon.ui.VisualLib;

/**
 * Speeds up DataEditor view creation, apparently by
 * causing the df, awt and os to init and cache various
 * objects and peers. Tenfold speed improvement by reducing
 * time from 12 to ??? seconds
 * <p>
 * We accomplish this by simulating creating a view with
 * most widgets and classes used by DataView.
 * <p>
 * Used in gov.cdc.atsdr.client.UserSecurity, resulting in
 * a mere 5% faster on 1st time for 20sec task.
 *
 * @author Jack Harich
 */
// setController() disabled to get to compile - JH

public class ViewSpeedup implements Runnable {

//---------- Private Fields ------------------------------

//---------- Initialization ------------------------------
// java org.jcon.df.edit.ViewSpeedup
public static void main(String args[]) {
    new ViewSpeedup().runUnitTest();
}
//---------- Runnable Implementation ---------------------
/**
 * For internal use only.
 */
public void run() {
    print(".run() - Entered");
        createView().close();
    print(".run() - Leaving");
}
//---------- Public methods ------------------------------
/**
 * To provoke the speedup call this method once. It runs
 * the speedup in a low priority thread, so as not to
 * slow down the application.
 */
public void speedup() {
    Thread thread = new Thread(this);
    thread.setPriority(Thread.MIN_PRIORITY);
    thread.start();
}
/**
 * For testing.
 */
public DataView createView() {

    DataView view = new DataView();

    // Properties
    view.setTitle("Edit UserSys Table");
    view.setPrimeView(true);
    // Some - view.setWindowPosition("XXX");
    // Some - view.setWindowSize(123, 123);

    // Add modules
    EasyLayout layout = view.getEasyLayout();

    // later BorderPanel border = new BorderPanel();

    addRowFieldPanel(view, layout);
    addMoveButtonBar(view, layout);
    addEditButtonBar(view, layout);

    // Done
    view.init();
    return view;
}
public void runUnitTest() {
    VisualLib.installLookAndFeel(); // Done by df

    // Do speedup
    // Comment out speedup() to see performance hit on first createView()
    print("Running speedup() in thread");
    speedup();
    try {
        Thread.currentThread().sleep(5000);
    } catch(InterruptedException ex) {
        print(" - interrupted");
    }
    // Test
    print(" - Starting test " + BenchMark.startTimeSeries(0));
    DataView[] views = new DataView[5];
    for (int i = 0; i < views.length; i++) {
        views[i] = createView();
        print(" - Time to create view " + i + " = " + BenchMark.getTimeElapsed(0));
    }
    print(" - Test done, total time = " + BenchMark.getTimePoint(0));
    // Show last view
    views[0].setVisible(true);
}
//---------- Private Methods -----------------------------
private void addRowFieldPanel(DataView view, EasyLayout layout) {
    RowFieldPanel module = new RowFieldPanel();
    view.addModule(module);
    module.setEditListener(view);
    layout.add(module.getComponent(), "Default", "EndRow");
    layout.beginNestedContainer();

    // UserID - first component
    createLabel("User ID", "FieldRight", layout);

    TextFieldControl userIDControl = new TextFieldControl(10);
    //***userIDControl.setController(view);
    userIDControl.setFirstComponent(true);
    userIDControl.setColumnID("UserSys.UserID");
    layout.add(userIDControl.getComponent(), "FieldLeft", "EndRow");

    // IsAdmin
    createLabel("Is Admin", "FieldRight", layout);

    BooleanControl isAdminControl = new BooleanControl();
    //***isAdminControl.setController(view);
    isAdminControl.setColumnID("UserSys.UserID");
    layout.add(isAdminControl.getComponent(), "FieldLeft", "EndRow");

    // Link
    createLabel("Link", "FieldRight", layout);

    LinkControl linkControl = new LinkControl();
    layout.add(linkControl.getComponent(), "FieldLeft", "EndRow");

    layout.endNestedContainer();
}
private void createLabel(String text, String style, EasyLayout layout) {
    layout.add(new LabelControl(text).getComponent(), style);
}
private void createTextField(String columnID, int columns,
        String style, String addType,
        EasyLayout layout, DataView view) {

    TextFieldControl control = new TextFieldControl(columns);
    //***control.setController(view);
    layout.add(control.getComponent(), style, addType);

}
private void addMoveButtonBar(DataView view, EasyLayout layout) {
    MoveButtonBar module = new MoveButtonBar();
    view.addModule(module);
    module.setEditListener(view);
    module.setDataSourceID("UserSysSource");

    layout.add(module.getComponent(), "GapTopBottomLeft", null);
}
private void addEditButtonBar(DataView view, EasyLayout layout) {
    EditButtonBar module = new EditButtonBar();
    view.addModule(module);
    module.setEditListener(view);
    module.setDataSourceID("UserSysSource");

    layout.add(module.getComponent(), "GapTopBottomRight", null);
}
//---------- Other
//--- Std
private static void print(String text) {
    System.out.println("ViewSpeedup" + text);
}

} // End class
