package org.jcon.df.edit;

import org.jcon.df.work.Row;
import org.jcon.param.Param;
import org.jcon.param.ParamConverter;
//import org.jcon.util.GenLib;
import java.util.Vector;

/**
 * DataEditor unit test: java org.jcon.df.edit.Test
 *
 * @author Jack Harich
 */
public class Test {

//---------- Private Fields ------------------------------

//---------- Initialization ------------------------------
public static void main(String args[]) {
    new Test().runUnitTest();
}
//---------- Public Methods ------------------------------
public void runUnitTest() {
    // *** No longer works due to further DataEditor implementation
    DataEditor editor = new DataEditor();
    editor.setParam(createParam());
    editor.start();
}
public static Vector getRows() {
    Vector rows = new Vector();
    for (int i = 1; i <= 4; i ++) {
        rows.addElement(getNewRow(i));
    }
    return rows;
}
private static Row getNewRow(int prefix) {
    Row row = new Row();
    row.setValue("SysUser.UserID", prefix + "ID");
    row.setValue("SysUser.Password", prefix + "Pass");
    row.setValue("SysUser.AdminCode", prefix + "Code");

    row.setValue("SysUser.SSN", prefix + "19-56-1107");

    row.setValue("SysUser.FirstName", prefix + "First");
    row.setValue("SysUser.MiddleInitial", prefix + "");
    row.setValue("SysUser.LastName", prefix + "Last");

    row.setValue("SysUser.LastLogon", prefix + "/3/98");

    return row;
} // Now done by entity - This is for getRows()
//----------
public Param createParam() {

String text = "" +
"ViewNames is: SysUserView\n" +
"DataSourceIDs  is: SysUserSource\n" +

"SysUserSource has:\n" +
"    Database is: atsdr\n" +
"    Entity is: SysUser\n" +
"    DataRequest has:\n" +
"        ColumnIDs hasLines:\n" +
"            *.SysUser\n" +
"            End: ColumnIDs\n" +
"        Entities is: SysUser\n" +
"        End: DataRequest\n" +
"   End: SysUserSource\n" +

"SysUserView has:\n" +
"   Title is: Unit Test Title\n" +
"   Workers has:\n" +
"       RowFieldPanel has:\n" +
"           Type is: org.jcon.df.edit.RowFieldPanel\n" +
"           Style is: Default\n" +
"           AddType is: EndRow\n" +
"           DataSourceID is: SysUserSource\n" +
"           NestedContainer has:\n" +
// UserID
"               UserIDLabel has:\n" +
"                   Type is: Label\n" +
"                   Style is: FieldRight\n" +
"                   Text is: User ID\n" +
"                   End: UserIDLabel\n" +
"               UserIDField has:\n" +
"                   Type is: TextField\n" +
"                   FirstComponent is: true\n" +
"                   Style is: FieldLeft\n" +
"                   AddType is: EndRow\n" +
"                   Columns is: 10\n" +
"                   ColumnID is: SysUser.UserID\n" +
"                   End: UserIDField\n" +
// Password
"               PasswordLabel has:\n" +
"                   Type is: Label\n" +
"                   Style is: FieldRight\n" +
"                   Text is: Password\n" +
"                   End: PasswordLabel\n" +
"               PasswordField has:\n" +
"                   Type is: TextField\n" +
"                   Style is: FieldLeft\n" +
"                   AddType is: EndRow\n" +
"                   Columns is: 10\n" +
"                   ColumnID is: SysUser.Password\n" +
"                   End: PasswordField\n" +
// AdminCode
"               AdminCodeLabel has:\n" +
"                   Type is: Label\n" +
"                   Style is: FieldRight\n" +
"                   Text is: Admin Code\n" +
"                   End: AdminCodeLabel\n" +
"               AdminCodeField has:\n" +
"                   Type is: TextField\n" +
"                   Style is: FieldLeft\n" +
"                   AddType is: EndRow\n" +
"                   Columns is: 7\n" +
"                   ColumnID is: SysUser.AdminCode\n" +
"                   End: AdminCodeField\n" +
// SSN
"               SSNLabel has:\n" +
"                   Type is: Label\n" +
"                   Style is: FieldRight\n" +
"                   Text is: SSN\n" +
"                   End: SSNLabel\n" +
"               SSNField has:\n" +
"                   Type is: TextField\n" +
"                   Style is: FieldLeft\n" +
"                   AddType is: EndRow\n" +
"                   Columns is: 11\n" +
"                   ColumnID is: SysUser.SSN\n" +
"                   End: SSNField\n" +
// FirstName
"               FirstNameLabel has:\n" +
"                   Type is: Label\n" +
"                   Style is: FieldRight\n" +
"                   Text is: First Name\n" +
"                   End: FirstNameLabel\n" +
"               FirstNameField has:\n" +
"                   Type is: TextField\n" +
"                   Style is: FieldLeft\n" +
"                   AddType is: EndRow\n" +
"                   Columns is: 20\n" +
"                   ColumnID is: SysUser.FirstName\n" +
"                   End: FirstNameField\n" +
// MiddleInitial
"               MiddleInitialLabel has:\n" +
"                   Type is: Label\n" +
"                   Style is: FieldRight\n" +
"                   Text is: Initial\n" +
"                   End: MiddleInitialLabel\n" +
"               MiddleInitialField has:\n" +
"                   Type is: TextField\n" +
"                   Style is: FieldLeft\n" +
"                   AddType is: EndRow\n" +
"                   Columns is: 1\n" +
"                   ColumnID is: SysUser.MiddleInitial\n" +
"                   End: MiddleInitialField\n" +
// LastName
"               LastNameLabel has:\n" +
"                   Type is: Label\n" +
"                   Style is: FieldRight\n" +
"                   Text is: Last Name\n" +
"                   End: LastNameLabel\n" +
"               LastNameField has:\n" +
"                   Type is: TextField\n" +
"                   Style is: FieldLeft\n" +
"                   AddType is: EndRow\n" +
"                   Columns is: 20\n" +
"                   ColumnID is: SysUser.LastName\n" +
"                   End: LastNameField\n" +
// LastLogon
"               LastLogonLabel has:\n" +
"                   Type is: Label\n" +
"                   Style is: FieldRight\n" +
"                   Text is: Last Logon\n" +
"                   End: LastLogonLabel\n" +
"               LastLogonField has:\n" +
"                   Type is: TextField\n" +
"                   Style is: FieldLeft\n" +
"                   AddType is: EndRow\n" +
"                   Columns is: 20\n" +
"                   ColumnID is: SysUser.LastLogon\n" +
"                   End: LastLogonField\n" +

"               End: NestedContainer\n" +
"          End: RowFieldPanel\n" +
"       MoveButtonBar has:\n" +
"           Type is: org.jcon.df.edit.MoveButtonBar\n" +
"           Style is: GapTopBottomLeft\n" +
"           DataSourceID is: SysUserSource\n" +
"           End: MoveButtonBar\n" +
"       EditButtonBar has:\n" +
"           Type is: org.jcon.df.edit.EditButtonBar\n" +
"           Style is: GapTopBottomRight\n" +
"           AddType is: EndRow\n" +
"           DataSourceID is: SysUserSource\n" +
//"            StyleProperties has:\n" +
//"                   Insets is: 4, 4, 4, 4\n" +
//"                   End: StyleProperties\n" +
"          End: EditButtonBar\n" +
"      End: Workers\n" +
"   End: SysUserView\n" +
"";
return ParamConverter.toParam(text);
} // End method

public static Param createEntityParam() {

String text = "" +
"Name is: SysUser\n" +
"UniqueIndexes is: UserID\n" +
"Columns hasElements:\n" +

"    Element:\n" +
"        Type is: String\n" +
"        Name is: UserID\n" +
"        MaxLength is: 10\n" +
"        Required is: true\n" +
"        End: Element\n" +
"    Element:\n" +
"        Type is: String\n" +
"        Name is: Password\n" +
"        MaxLength is: 10\n" +
"        Required is: true\n" +
"        End: Element\n" +
"    Element:\n" +
"        Type is: String\n" +
"        Name is: AdminCode\n" +
"        DisplayName is: Admin Code\n" +
"        MaxLength is: 7\n" +
"        Required is: true\n" +
"        End: Element\n" +

"    Element:\n" +
"        Type is: Mask\n" +
"        Name is: SSN\n" +
"        Mask is: 999-99-9999\n" +
"        End: Element\n" +

"    Element:\n" +
"        Type is: String\n" +
"        Name is: FirstName\n" +
"        MaxLength is: 20\n" +
"        Required is: true\n" +
"        End: Element\n" +
"    Element:\n" +
"        Type is: String\n" +
"        Name is: MiddleInitial\n" +
"        MaxLength is: 1\n" +
"        End: Element\n" +
"    Element:\n" +
"        Type is: String\n" +
"        Name is: LastName\n" +
"        MaxLength is: 20\n" +
"        Required is: true\n" +
"        End: Element\n" +

"    Element:\n" +
"        Type is: Date\n" +
"        Name is: LastLogon\n" +
"        DisplayName is: Last Logon Date\n" +
"        Required is: true\n" +
"        End: Element\n" +

"    End: Columns\n" +
"";
return ParamConverter.toParam(text);
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("Test" + text);
}

} // End class
