package org.jcon.df.edit;

import org.jcon.df.edit.EditEvent;
import org.jcon.df.edit.Task;
import org.jcon.df.edit.TaskLogicFascade;
import org.jcon.df.edit.widget.WidgetSet;
import org.jcon.util.msg.Message;
import org.jcon.util.msg.MessageDef;
import org.jcon.util.service.ContainerServices;
import java.util.Vector;

/**
* This abstract class is the standard for tasks to
* subclass. This approach allows a less breakable
* interface, since this class implements that interface
* and subclasses need not implement all methods.
*
* @author Jack Harich
*/
public abstract class TaskStandard implements Task {

//---------- Protected Fields ----------------------------
//----- Properties
protected TaskLogicFascade  taskLogicFascade;
protected ContainerServices containerServices;
//----- Internal
protected WidgetSet widgetSet;

//---------- Task Implementation -------------------------
public void setTaskLogicFascade(TaskLogicFascade fascade) {
    taskLogicFascade = fascade;
}
public void setContainerServices(ContainerServices services) {
    containerServices = services;
}
public void start(Message message) {
    widgetSet = taskLogicFascade.getWidgetSet("MainView");
}
public void closeWindowRequested(String viewName) {
    taskLogicFascade.closeView(viewName);
}

public void processEditEvent(EditEvent evt) {
    // Ignore
}
public void commandRequested(String viewName, String command) {
    // *** do
}
public void processMessage(Message message) {
    // Do nothing
}
public String[] loadMessageInterests() {
    return new String[0];
}
public Vector getMessageDefs() {
    return new Vector(); // None
}
//---------- Protected Methods ---------------------------
protected void sendTaskMessage(Message message) {
    taskLogicFascade.sendMessage(message);
}


} // End class
