package org.jcon.df.edit;

import org.jcon.df.edit.widget.WidgetSet;
import org.jcon.util.msg.Message;
import org.jcon.util.service.ContainerServices;

/**
* This interface is a Fascade for TestLogic. The use of a
* Fascade avoids exposing all the TaskLogic's methods,
* thus allowing looser coupling. The methods are all of
* what the Task needs to manupulate the views.
*
* @author Jack Harich 
*/

public interface TaskLogicFascade {

/**
* Returns the WidgetSet for the named view. This can be
* used to directly manipulate the view's controls and
* modules.
*/
public WidgetSet getWidgetSet(String viewName);

/**
* Sets the named view visibility.
*/
public void setVisibleView(String viewName);

/**
* Closes the named view permanently.
*/
public void closeView(String viewName);

/**
* Causes the Fascade to query its views to see if they
* can close. Returns null for yes or an explanation of
* why can't close. NOTE - Currently the Fascade does NOT
* query the views and always returns null.
*/
public String canClose();

/**
* Causes the Fascade to close permanently. This must be
* called to end the task.
*/
public void close();

/**
* Causes the Message to be sent to listeners.
*/
public boolean sendMessage(Message message);


} // End interface
