package org.jcon.df.edit;

import org.jcon.util.msg.Message;
import org.jcon.util.msg.MessageListener;
import org.jcon.util.service.ContainerServices;
import java.util.Vector;

/**
* This interface represents a "task" the user needs to
* perform. Each task has one or more windows, which it
* can manipulate through the window's WidgetSet.
*
* @author Jack Harich 
*/

public interface Task extends MessageListener {

/**
* Sets the all important source of what the task needs to
* accomplish its view manipulation. 
*/
public void setTaskLogicFascade(TaskLogicFascade fascade);

/**
* Sets the entry point to the ContainerServices subsystem.
* This can be used to collaborate with other classes.
*/
public void setContainerServices(ContainerServices services);

/**
* The instance should start working, such as populating its
* view with data using ContainerServices.
* @param startMessage  the Message that TaskLogic received
*                      for its own start. This may contain
*                      task specific data,
*/
public void start(Message startMessage);

/**
* Notifies the task that the user has attempted to close the
* view named viewName. If there is only one window for the
* task then the viewName is irrelevant.
*/
public void closeWindowRequested(String viewName);

/**
* The task should check the event type and process it if
* desired. This is a polymorphic event.
*/
public void processEditEvent(EditEvent evt);

/**
* The task should process the command. This is a
* convenience method for EditEvent.COMMAND.
*/
public void commandRequested(String viewName, String command);

/**
* Returns a Vector of MessageDefs defining the Messages the
* task fires.
*/
public Vector getMessageDefs();

//---------- MessageListener 
/**
* The task should process the Message.
*/
// implied public void processMessage(Message message);

/**
* Returns an array of the Message names the task is
* interested in, or a zero length array if none.
*/
// implied public String[] loadMessageInterests();


} // End interface

/* ============= Skeleton ================================

import org.jcon.util.msg.Message;
import org.jcon.util.msg.MessageDef;
import org.jcon.df.edit.EditEvent;
import org.jcon.df.edit.Task;
import org.jcon.df.edit.TaskLogicFascade;
import org.jcon.util.service.ContainerServices;

//---------- Task Implementation -------------------------
public void setTaskLogicFascade(TaskLogicFascade fascade) {
    taskLogicFascade = fascade;
}
public void setContainerServices(ContainerServices services) {
    containerServices = services;
}
public void start() {
    // *** do
}
public void closeWindowRequested(String viewName) {
    // *** do
}
public void processEditEvent(EditEvent evt) {
    // Ignore
}
public void commandRequested(String viewName, String command) {
    // *** do
}
public void processMessage(Message message) {
    // Do nothing
}
public String[] loadMessageInterests() {
    return new String[0];
}
public Vector getMessageDefs() {
    return new Vector(); // None
}

*/
