package org.jcon.df.edit;

import org.jcon.util.msg.Message;
import org.jcon.df.Database;
import org.jcon.df.work.Row;
import org.jcon.df.column.ColumnDef;

/**
 * Represents an event occuring during an edit. Many
 * such events can occur and need to be processed by a
 * single listener (controller), so this is a configurable
 * event. Some eventTpes are acquire events.
 * <p>
 * As anticipated, we ran out of extensibility in the use
 * of static IDs for event type, and fixed properties.
 * On 2/5/99 we added the Message feature, allowing the
 * use of this class to transport Messages of any kind.
 * Thus the event plumbing remains intact, but we can now
 * support events of any kind. NO MORE FIXED EVENT TYPES
 * SHOULE BE ADDED - Use Messages instead.
 *
 * @author Jack Harich
 */
public class EditEvent {

//---------- Public Fields -------------------------------
public static final int MOVE_TO          = 1;
public static final int BEGIN_ADD        = 2;
public static final int BEGIN_CHANGE     = 3;
public static final int BEGIN_DELETE     = 4;
public static final int OKAY_ADD         = 5;
public static final int OKAY_CHANGE      = 6;
public static final int CANCEL_ADD       = 7;
public static final int CANCEL_CHANGE    = 8;
public static final int CLOSE            = 9;
public static final int EDIT_STATE_CHANGED  = 10;
public static final int ACQUIRE_COLUMN_DEF  = 11;
public static final int ROW_INDEX_ACTIVATED = 12;

// Used by LinkControl to populate itself. Uses Database.
public static final int ACQUIRE_DATABASE    = 13;

// Uses property Command
public static final int COMMAND             = 14;

// Uses property Hyperlink
public static final int HYPERLINK_ACTIVATED = 15;

// There are for non-DataEditor events
public static final int NON_TYPICAL         = 100;

// Uses properties workerName, isSelected
public static final int TOGGLE_STATE_CHANGED   = 101;

// Uses property workerName
public static final int LIST_SELECTION_CHANGED = 102;

// Other
public static final int HELP_REQUESTED = 201;
public static final int MESSAGE = 202;

//---------- Private Fields ------------------------------
private int       eventType;
private String    dataSourceID;
private String    position;
private Row       row;
private String    viewName;
private String    editState;
private ColumnDef columnDef;
private String    columnID;
private int       rowIndex;
private Database  database;
private String    command;
private String    helpId;
private Message   message;

private String    workerName;
private boolean   isSelected;
private String    hyperlink;

//---------- Initialization ------------------------------
public EditEvent(int eventType, String dataSourceID) {
    this.eventType = eventType;
    this.dataSourceID = dataSourceID;
}
//---------- Superclass Overrides ------------------------
public String toString() {
    return getEventTypeString();
}
//---------- Properties ----------------------------------
//----- eventType
public int getEventType() {
    return eventType;
}
public String getEventTypeString() {
    if (eventType == MOVE_TO) return "MoveTo";
    if (eventType == BEGIN_ADD) return "BeginAdd";
    if (eventType == BEGIN_CHANGE) return "BeginChange";
    if (eventType == BEGIN_DELETE) return "BeginDelete";
    if (eventType == OKAY_ADD) return "OkayAdd";
    if (eventType == OKAY_CHANGE) return "OkayChange";
    if (eventType == CANCEL_ADD) return "CancelAdd";
    if (eventType == CANCEL_CHANGE) return "CancelChange";
    if (eventType == CLOSE) return "Close";
    if (eventType == EDIT_STATE_CHANGED) return "EditStateChanged";
    if (eventType == ACQUIRE_COLUMN_DEF) return "AcquireColumnDef";
    if (eventType == ROW_INDEX_ACTIVATED) return "RowIndexActivated";
    if (eventType == ACQUIRE_DATABASE) return "AcquireDatabase";
    if (eventType == COMMAND) return "Command";    
    if (eventType == TOGGLE_STATE_CHANGED) return "ToggleStateChanged";
    if (eventType == HELP_REQUESTED) return "HelpRequested";
    if (eventType == HYPERLINK_ACTIVATED) return "HyperlinkActivated";
    if (eventType == MESSAGE) return "Message";

    return "#UnknownType#";
}
//----- dataSourceID
public String getDataSourceID() {
    return dataSourceID;
}
//----- position
public void setPosition(String position) {
    this.position = position;
}
public String getPosition() {
    return position;
}
//----- row
public void setRow(Row row) {
    this.row = row;
}
public Row getRow() {
    return row;
}
//----- viewName
public void setViewName(String viewName) {
    this.viewName = viewName;
}
public String getViewName() {
    return viewName;
}
//----- editState
public void setEditState(String editState) {
    this.editState = editState;
}
public String getEditState() {
    return editState;
}
//----- columnDef
public void setColumnDef(ColumnDef columnDef) {
    this.columnDef = columnDef;
    //if (columnDef!= null) print(".setColumnDef() - name = " + columnDef.getName());
}
public ColumnDef getColumnDef() {
    return columnDef;
}
//----- columnID
public void setColumnID(String columnID) {
    this.columnID = columnID;
}
public String getColumnID() {
    return columnID;
}
  // joshy
  //----- columnID
  public void setHelpId(String helpId) {
    this.helpId = helpId;
  }
  public String getHelpId() {
    return helpId;
  }
  // end joshy
//----- rowIndex
public void setRowIndex(int rowIndex) {
    this.rowIndex = rowIndex;
}
public int getRowIndex() {
    return rowIndex;
}
//----- database
public void setDatabase(Database database) {
    this.database = database;
}
public Database getDatabase() {
    return database;
}
//----- command
public void setCommand(String command) {
    this.command = command;
}    
public String getCommand() {
    return command;
}
//----- workerName
public void setWorkerName(String workerName) {
    this.workerName = workerName;
}
public String getWorkerName() {
    return workerName;
}
//----- isSelected
public void setSelected(boolean isSelected) {
    this.isSelected = isSelected;
}
public boolean isSelected() {
    return isSelected;
}
//----- hyperlink
public void setHyperlink(String hyperlink) {
    this.hyperlink = hyperlink;
}
public String getHyperlink() {
    return hyperlink;
}
//----- message
/**
* Sets the Message property for MESSAGE events.
*/
public void setMessage(Message message) {
    if (eventType != MESSAGE) throw new IllegalArgumentException(
        "Can only setMessage() if MESSAGE event type.");
    this.message = message;
}
/**
* Returns the Message representing this event. If a
* MESSAGE event type, this is the original unalatered Message.
* Otherwise it is a translation of the properties, with 
* the Message name always "EditEvent" and a property 
* "EventType" with a String value, not an int.
* *** Note - All types not yet implemented - JH
*/
public Message getMessage() {
    if (message != null) {
        return message; // Unaltered
        
    } else if (eventType == COMMAND) {
        Message mess = new Message("EditEvent");
        mess.set("EventType", "Command");
        mess.set("Command", getCommand());
        return mess;
    
    } else {
        throw new IllegalStateException("getMessage() not "
        + "yet implemented for event type " + getEventTypeString());
    }
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("EditEvent" + text);
}

} // End class
