package org.jcon.df.edit;

import org.jcon.df.DatastoreServices;
import java.util.Hashtable;

/**
 * The interface for a DataEditor task. This allows a hard
 * coded implementation to replace a Param for speed.
 *
 * @author Jack Harich
 */
public interface DataEditorTask {

/**
 * The task should initialize itself, such as preparing
 * views and sources. Call this method after setting the
 * above task properties.
 */
public void init();

/**
 * Returns the DataViews for the task. Called after init().
 */
public Hashtable getDataViews();

/**
 * Returns the DataSources for the task. Called after init().
 */
public Hashtable getDataSources();

/**
 * The task should start itself. This includes showing the
 * prime view.
 */
// *** public void start();


} // End interface
