package org.jcon.df.column;

import org.jcon.param.Param;
/**
 * The TimeStampColumn field. This is maintained automatically
 * by the database. It is useful for concurrency and misc.
 * This column is in all entities.
 *
 * @author Jack Harich
 */

public class TimeStampColumn extends ColumnDef {

//---------- Initialization ------------------------------
public TimeStampColumn() {
    super();
    super.setName("TStamp"); // "TimeStamp" is reserved word in MSAccess
    super.setRequired(false); // Since hidden in edit
    type = "TimeStamp";
    setDefaultValue("");
}
//---------- Abstract Implementation ---------------------
public void initFromParam(Param param) {
    checkStandardProperties(param); // superclass
}
/**
  * This method always returns null. It is not used since
  * this class is maintained by the database and never
  * edited by the user.
  */
public String validateString(String value) {
    return null;
}
public String getMyPropertySummary() {
    return "Maintained by database";
}
//---------- Superclass Overrides ------------------------
public String getPropertySummary() {
    return getMyPropertySummary();
}
public int getPreferredLength() {
    return 20; // Estimate for possible future use
}


} // End class
