package org.jcon.df.column;

import org.jcon.param.Param;

/**
 * A Java String of arbitrary length. There are
 * no content restrictions.
 *
 * This class represents an empty value as "".
 *
 * @author Jack Harich
 */

public class MemoColumn extends ColumnDef {

//---------- Private Fields ------------------------------
private boolean autotrim         = true;
private int     preferredRows    = 3;
private int     preferredColumns = 50;

//---------- Initialization ------------------------------
/**
 * No-arg to allow serialization.
 */
public MemoColumn() {
    super();
    setDefaultValue("");
    type = "Memo";
}
/**
 * A convience constructor. Also sets default to "".
 */
public MemoColumn(String name) {
    this();
    setName(name);
}
//---------- Abstract Implementation ---------------------
public void initFromParam(Param param) {
    checkStandardProperties(param); // superclass

    if (param.hasProperty("PreferredRows")) {
        preferredRows = param.getInt("PreferredRows");
    }
    if (param.hasProperty("PreferredColumns")) {
        preferredColumns = param.getInt("PreferredColumns");
    }
}
/**
 * No check since anything may be entered.
 */
public String validateString(String text) {
     return null;
}
public String getMyPropertySummary() {
    return "Unlimited length,";
}
//---------- Public Methods ------------------------------
/**
 * If autotrim is true then whenever the value is set it
 * will be trimmed of leading and trailing spaces. The
 * default is true, which is highly recommended.
 */
public void setAutotrim(boolean autotrim) {
    this.autotrim = autotrim;
}
public boolean isAutotrim() {
    return autotrim;
}
//----- preferredRows
public void setPreferredRows(int preferredRows) {
    this.preferredRows = preferredRows;
}
public int getPreferredRows() {
    return preferredRows;
}
//----- preferredColumns
public void setPreferredColumns(int preferredColumns) {
    this.preferredColumns = preferredColumns;
}
public int getPreferredColumns() {
    return preferredColumns;
}
//---------- Private Methods -----------------------------
private void print(String text) {
    System.out.println(text);
}

} // End class
