package org.jcon.df.column;

import org.jcon.param.Param;

/**
 * The MemberID field.
 *
 * Internally the defaultValue is "", which allows a
 * foreign key column to be required or not.
 *
 * @author Jack Harich
 */

public class MIDColumn extends ColumnDef {

//---------- Private Fields ------------------------------
private String linkEntityName;

//---------- Initialization ------------------------------
/**
 * This constructor sets name to "MID", defaultValue
 * to "", required to true and unique to true. This is for
 * primary keys.
 */
public MIDColumn() {
    super();
    super.setName("MID");
    super.setRequired(false); // Since hidden in edit
    super.setUnique(true);    // Since primary key
    super.setDefaultValue(""); // Important
    type = "MID";
}
/**
 * Use this constructor to declare the column name. This is
 * for foreign key columns. The defaultValue is "",
 * required is false and unique is false.
 */
public MIDColumn(String name) {
    super();
    super.setName(name);
    super.setRequired(false); // Since hidden in edit
    super.setUnique(false);   // Since foreign key
    super.setDefaultValue(""); // Important
    type = "MID";
}
//---------- Abstract Implementation ---------------------
public void initFromParam(Param param) {
    checkStandardProperties(param); // superclass
    linkEntityName = param.getString("LinkEntityName"); // Required
}
/**
  * This method always returns null. It is not used since
  * an MID is immutable. It is provided only since we must
  * extend ColumnDef.
  */
public String validateString(String value) {
    return null;
}
public String getMyPropertySummary() {
    if (linkEntityName == null) {
        return "PrimaryKey,";
    } else {
        return "LinkTo=" + linkEntityName + ",";
    }
}
//---------- Superclass Overrides ------------------------
public int getPreferredLength() {
    return 20; // *** For now, will use combo box...
}
//---------- Public Methods ------------------------------
/**
 * Returns null if none, which means this is a primary key.
 */
public String getLinkEntityName() {
    return linkEntityName;
}
public void setLinkEntityName(String linkEntityName) {
    this.linkEntityName = linkEntityName;
}


} // End class
