package org.jcon.df.column;

import org.jcon.param.Param;
import org.jcon.util.GenLib;

/**
 * Creates ColumnDefs on demand.
 *
 * @author Jack Harich
 */
public class ColumnDefFactory {

//---------- Public Methods ------------------------------
public static ColumnDef create(String name, Param param) {
    // Note class name convention
    String type = param.getString("Type");
    String className = "org.jcon.df.column." + type + "Column";

    ColumnDef def = (ColumnDef)GenLib.createInstance(className);
    //print(".createColumnDef() - created " + def.getClass().getName());
    def.setName(name);
    def.initFromParam(param);

    return def;
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("ColumnDefFactory" + text);
}

} // End class
