package org.jcon.df;

import org.jcon.util.DataLib;

/**
 * Represents a unique index in an entity. A unique index
 * consists of one or more columns that (together) must be
 * unique for all rows in the entity.
 *
 * If an entity contains a code column that should be
 * unique, the entity should have a UniqueIndex for that
 * column. Ditto for multiple column indexes.
 *
 * Later this may have a name.
 *
 * @author Jack Harich
 */
public class UniqueIndex implements java.io.Serializable {

//---------- Private Fields ------------------------------
// These do not include entityName
private String[] columnNames;
private String delimColumnNames;

//---------- Initialization ------------------------------
public UniqueIndex(String delimColumnNames) {
    this.delimColumnNames = delimColumnNames;
    columnNames = DataLib.convertDelimStringToArray(delimColumnNames, ", ");
}
//---------- Public Methods ------------------------------
public String[] getColumnNames() {
    return columnNames;
}
public String getDelimColumnNames() {
    return delimColumnNames;
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("UniqueIndex" + text);
}

} // End class
