package org.jcon.df;

/**
 * The interface for a system user. This allows the data
 * framework to identify the client user without tight
 * coupling to the particular client implementation.
 * The implementer should be Serializable.
 *
 * @author Jack Harich
 */
public interface SystemUser {

/**
 * Returns the UserID, which should be unique per user.
 */
public String getUserID();

/**
 * Returns user's full name in "alphabetical" format, which
 * is "LastName, FirstName Initial".
 */
public String getAlphabeticalFullName();



} // End interface

/**

import org.jcon.df.SystemUser;

//---------- SystemUser Implementation -------------------
public String getUserID() {
    return userID;
}
public String getAlphabeticalFullName() {
    return "AlphabeticalFullName not implemented";
}


*/
