package org.jcon.df;

/**
 * The interface for EntityEvent listeners. We are using
 * the Polymorphic Event pattern here. This allows a single
 * event and interface method to represent many discrete
 * events. Additional event types can be added without
 * breaking any existing code. 
 *
 * @author Jack Harich
 */
public interface EntityListener {


/**
 * The listener should process the event. If the event
 * deserves a reply then EntityEventReply is returned.
 * Otherwise null is returned.
 * <p>
 * An example of a reply is to invalidate a row mutation.
 */
public EntityEventReply processEntityEvent(EntityEvent evt);


} // End interface
