package org.jcon.df;
         
/**
* This class contains a reply to an EntityEvent. By not
* putting the reply in the event we gain clearer and
* smaller class responsibilities. This class is designed to
* have behavior added as needed.
*/
public class EntityEventReply implements java.io.Serializable {  

//---------- Private Fields ------------------------------ 
private String  invalidColumnName;
private String  invalidMessage;
             
//---------- Properties ----------------------------------
//----- invalidColumnName   
/**
* This indicates the name of the invalid column. This is
* useful in the GUI to return the focus to the problem
* spot if an invalidation occurs.
*/
public void setInvalidColumnName(String invalidColumnName) {
    this.invalidColumnName = invalidColumnName;
}
public String getInvalidColumnName() {
    return invalidColumnName;
}         
//----- invalidMessage;
/**
* Sets the InvalidMessage property, which will be shown to
* the user to describe the problem.
*/
public void setInvalidMessage(String invalidMessage) {
    this.invalidMessage = invalidMessage;    
}             
public String getInvalidMessage() {
    return invalidMessage;        
}   
//----- Other
/**
* Returns true if this is an "invalid" reply, false if not.
* This distinction allows additional types of replies in
* the future.
*/
public boolean isInvalid() {
    return (invalidMessage != null ? true : false);    
}  

} // End class










