package org.jcon.df;

import org.jcon.df.work.Row;

/**
 * This event is fired when an entity state change is
 * about to occur or has occurred. This allows entity
 * integrity to be enforced. More events will be added
 * as needed.
 * <p>
 * This event is designed to let listeners disapprove a
 * state change, which is called invalidating a validation
 * event. We use a cleaner mechanism than throwing an
 * exception, since in the author's opinion this is a
 * abuse of what exceptions are designed for, and tends to
 * muddy the design and implementation.
 *
 * @author Jack Harich
 */
public class EntityEvent implements java.io.Serializable {

//---------- Public Fields -------------------------------
public static final int VALIDATE_ADD    = 1;
public static final int VALIDATE_UPDATE = 2;
public static final int VALIDATE_DELETE = 3;

//---------- Private Fields ------------------------------
private int     eventType;
private String  dbName;
private String  entityName;
private Row     row;
private boolean isSingleRow = true; // For future use
// private transient Database database; - For possible future use

//---------- Initialization ------------------------------
public EntityEvent(int eventType) {
    this.eventType = eventType;
}
//---------- Superclass Overrides ------------------------
public String toString() {
    return getEventTypeString();
}
//---------- Properties ----------------------------------
//----- eventType
public String getEventTypeString() {
    if (eventType == VALIDATE_ADD) return "ValidateAdd";
    if (eventType == VALIDATE_UPDATE) return "ValidateUpdate";
    if (eventType == VALIDATE_DELETE) return "ValidateDelete";

    return "#UnknownType#";
}
public int getEventType() {
    return eventType;
}      
//----- dbName
public void setDatabaseName(String databaseName) {
   dbName = databaseName;
}
public String getDatabaseName() {
        return dbName;
}   
//----- entityName
public void setEntityName(String entityName) {
    this.entityName = entityName;
} 
public String getEntityName() {
        return entityName;
}     
//----- row
public void setRow(Row row) {
    this.row = row;
}
public Row getRow() {
    return row;    
}    
//----- isSingleRow 
// Setter later
public boolean isSingleRow() {
    return isSingleRow;
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("EntityEvent" + text);
}

} // End class




