package org.jcon.df;

/**
 * Represents a child in a parent/child relationship.
 * For example, the Award table has child entities
 * AwardStage and AwardRecipient.
 *
 * @author Jack Harich
 */
public class EntityChild implements java.io.Serializable {

//---------- Private Fields ------------------------------
private String entityName;
private String columnName;

//---------- Initialization ------------------------------
public EntityChild(String entityName, String columnName) {
    this.entityName = entityName;
    this.columnName = columnName;
}
//---------- Properties ----------------------------------
public String getEntityName() {
    return entityName;
}
/**
 * The columnName is the child column pointing to the
 * parent record.
 */
public String getColumnName() {
    return columnName;
}
/**
 * A convenience method that returns the columnID, which is
 * "EntityName.ColumnName".
 */
public String getColumnID() {
    return entityName + "." + columnName;
}


} // End class
