package org.jcon.df;

// import org.jcon.util.GenLib;
import org.jcon.param.Param;

/**
 * Defines the parameters representing a physical database,
 * plus the logical name of that database.
 *
 * A physical database has: <BR>
 * - A logical name unique to this data framework <BR>
 * - A Schema defining the tables on that database <BR>
 * - A Connector defining the JDBC connection to that database <BR>
 * - A Translator, such as for Sybase or Access
 *
 * Note this approach allows schemas to be reused on differnt
 * databases. For example one can easily have a production
 * and test database with the same schema. One could be
 * on Sybase and the other on Access.
 *
 * The database name is the same as the Connector name. The
 * database type is the DatabaseType class name.
 *
 * @author Jack Harich
 */
public class DatabaseDef {

//---------- Private Fields ------------------------------
private String name;
private String schemaName;
private String translatorType;

//---------- Initialization ------------------------------
public DatabaseDef(Param param) {
    name = param.getString("DatabaseName");
    schemaName = param.getString("SchemaName");
    translatorType = param.getString("TranslatorType");
}
//---------- Properties ----------------------------------
public String getName() {
    return name;
}
public String getSchemaName() {
    return schemaName;
}
public String getTranslatorType() {
    return translatorType;
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("DatabaseDef" + text);
}

} // End class
