package org.jcon.df;

import org.jcon.util.GenLib;
import org.jcon.param.Param;
import org.jcon.param.ParamDriven;
import org.jcon.param.ParamDrivenInfo;
import java.util.Hashtable;
import java.util.Vector;

/**
 * Manages a collection of ConnectorDefs. Its most important
 * responsibility is providing Connectors.
 *
 * @author Jack Harich
 */
public class ConnectorMgr implements ParamDriven {

//---------- Private Fields ------------------------------
private Param     param;

// Key = dbName, Object = ConnectorDef
private Hashtable mutableConnectorDefs = new Hashtable();
private Hashtable readOnlyConnectorDefs = new Hashtable();

//---------- ParamDriven Implementation ------------------
public void setParam(Param param) {
    this.param = param;
    // Load connectorDefs
    loadDefs("MutatorConnectorDefs", mutableConnectorDefs);
    loadDefs("ReadOnlyConnectorDefs", readOnlyConnectorDefs);
//print(".setParam() - mutable count = " + mutableConnectorDefs.size());
}
private void loadDefs(String paramName, Hashtable connectorDefs) {
    connectorDefs.clear();
    Param defsParam = param.getParam(paramName);
    String[] dbNames = defsParam.getDataKeys();
    
    for (int i = 0; i < dbNames.length; i++) {
        String dbName = dbNames[i];
        Param defParam = defsParam.getParam(dbName);
        ConnectorDef def = new ConnectorDef(dbName, defParam);
        connectorDefs.put(dbName, def);
    }
}
public Param getParam() {
    return param;
}
public boolean applyNewParam(Param newParam) {
    setParam(newParam);
    return true; // Successful
}
public ParamDrivenInfo getParamDrivenInfo() {
    return null;
}
//---------- Public Methods ------------------------------
// Returns null for failure
public Connector createMutableConnector(String dbName) {
    ConnectorDef def = (ConnectorDef)mutableConnectorDefs.get(dbName);
    if (def == null) {
        GenLib.error("ConnectorMgr.createMutableConnector()",
            "Connector for database name '" + dbName + "' not found.");
        return null;
    } else {
        return new Connector(def);
    }
}
// Returns null for failure
public Connector createReadOnlyConnector(String dbName) {
    ConnectorDef def = (ConnectorDef)readOnlyConnectorDefs.get(dbName);
    if (def == null) {
        GenLib.error("ConnectorMgr.createReadOnlyConnector()",
            "Connector for database name '" + dbName + "' not found.");
        return null;
    } else {
        return new Connector(def);
    }
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("ConnectorMgr" + text);
}

} // End class
