package org.jcon.df;

import org.jcon.param.Param;

/**
 * Defines the parameters representing a JDBC database
 * connection. The DatabaseName is not unique per system,
 * due to the boolean Mutator property. This allows
 * ReadOnly (false) and ReadWrite (true) connectors.
 *
 * @author Jack Harich
 */
public class ConnectorDef implements java.io.Serializable {

//---------- Private Fields ------------------------------
private String  dbName;
private String  url;
private String  userID;
private String  password;
private String  driverClass;
private boolean mutator;

//---------- Initialization ------------------------------
public ConnectorDef(String databaseName, Param param) {
    dbName = databaseName;
    url = param.getString("URL");
    userID = param.getString("UserID");
    password = param.getString("Password");
    driverClass = param.getString("DriverClass");
    mutator = param.isTrue("IsMutator");
}
//---------- Properties ----------------------------------
public String getDatabaseName() {
    return dbName;
}
public String getURL() {
    return url;
}
public String getUserID() {
    return userID;
}
public String getPassword() {
    return password;
}
public String getDriverClass() {
    return driverClass;
}
public boolean isMutator() {
    return mutator;
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("ConnectorDef" + text);
}

} // End class
