package org.jcon.core.test1;

import org.jcon.core.Cell;
import org.jcon.core.CellUser;
import org.jcon.core.StartablePart;
import org.jcon.core.WorkerWrapper;
import org.jcon.core.std.WorkerWrapperStd;

/**
* This class instigates a test System Tree by adding
* various parts when started.
*
* @author Jack Harich
*/ 
public class Instigator1 implements CellUser,
    StartablePart {

//---------- Protected Fields ----------------------------
protected Cell cell;

//----------- CellUser Implementation --------------------
public void setCell(Cell cell) {
    this.cell = cell;
}
public void releaseCell() {
    cell = null;
}
//----------- StartablePart Implementation ---------------
public void startPart() {
    
    // Add a cell for dramatic replication test
    Cell cell2 = (Cell)cell.replicate();
    cell2.setName("Cell2");
    cell.addPart(cell2);
    
    WorkerWrapper wrapper;
    
    // Add test non-core worker part to cell
    wrapper = new WorkerWrapperStd();    
    wrapper.setName("Worker1");
    wrapper.setWorker(new Object());
    cell.addPart(wrapper);
    
    // Add test non-core worker part to cell2
    wrapper = new WorkerWrapperStd();    
    wrapper.setName("Worker2");
    wrapper.setWorker(new Object());
    cell2.addPart(wrapper);
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("Instigator1" + text);
}

} // End class