package org.jcon.core.std;

import org.jcon.core.Cell;
import org.jcon.core.CellTree;
import org.jcon.core.Part;
import java.util.Enumeration;

/**
* This class is the standard ContainerTree. For
* documentation see ContainerTree for now. 
*
* @author Jack Harich
*/
public class CellTreeStd implements CellTree {

//---------- ContainerTree Implementation ----------------
public Cell getRoot(Cell cell) {
    while (cell.getParent() != null) {
        cell = (Cell)cell.getParent();
    }
    return cell;
}
public String listTree(Cell cell) {
    String text = cell.getName();
    return text + "\n" + listCell(cell, 1);
}
//---------- Protected Methods ---------------------------
// RECURSIVE
protected String listCell(Cell cell, int level) {

    String text = ""; 
    Enumeration parts = cell.getParts();
    while (parts.hasMoreElements()) {
        Part part = (Part)parts.nextElement();
        // Build prefix of spaces, which is level * indent
        // Why doesn't Java have an easy way to do this?
        int indent = 4;
        int spaces = level * indent;
        String prefix = "";
        for (int j = 1; j <= spaces; j++) {
            prefix += " ";
        }
        // Build line
        text += prefix + part.getName() + "\n";
        
        // RECURSE if container
        if (part.isContainer()) {
            text += listCell((Cell)part, level + 1);            
        }
    }
    return text;
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("CellTreeStd" + text);
}

} // End class