package org.jcon.core.std;

import org.jcon.core.Cell;
import org.jcon.core.CellCreator;
import org.jcon.core.CellReplicator;
import org.jcon.core.WorkerWrapper;

import java.util.Vector;

/**
* This class is the standard CellCreator. For
* documentation see CellCreator for now. This is a
* "core service part" but is usually never used again
* after the root cell is created. Even though not needed,
* it should be in the system it created for completeness.
* <p>
* Note we can have different implementations for different
* styles of cores, such as one with no Messages and DK,
* one with DK byt no Messages, and one with DK and Messages.
* The first is very simple and lightweight, and may be
* useful for embedded systems or getting started with UHR.
* The variety offers the designer a range of functionality.
*
* @author Jack Harich
*/
public class CellCreatorStd implements CellCreator {

//---------- CellCreator Implementation ------------------
public Cell createPrimordialCell() {

    Cell newCell = new CellStd();
    newCell.setCore(true);
    newCell.setContainer(true);
    
    populateRootCell(newCell);
    newCell.initCell();
        
    return newCell;
}
//---------- Protected Methods ---------------------------
// Later from DK - Possible TODO
// Adds all necessary core parts to cell
protected void populateRootCell(Cell cell) {

    Vector names = new Vector();
    WorkerWrapper wrapper;
    
    // Later do more parts, use ParamStore, marker ???
    
    //----- Non-services
    // CellLifecycle
    wrapper = createCoreWorkerWrapper("CellLifecycle", 
        new CellLifecycleStd(), names);
    cell.addPart(wrapper);
    
    // CellServices
    wrapper = createCoreWorkerWrapper("CellServices", 
        new CellServicesStd(), names);
    cell.addPart(wrapper);

    //----- Services
    // CellTree, a service
    wrapper = createCoreWorkerWrapper("CellTree",
        new CellTreeStd(), names);
    wrapper.setService(true); 
    cell.addPart(wrapper);
    
    // Add myself, a service even though may not reuse.
    // It can be reused. such as one system creating another.
    wrapper = createCoreWorkerWrapper("CellCreator", 
        this, names);
    wrapper.setService(true); 
    cell.addPart(wrapper);
    
    //--------------- Do Last ----------------------------
    // CellReplicator, must be last to add all corePartNames
    CellReplicator replicator = new CellReplicatorStd();
    wrapper = createCoreWorkerWrapper("CellReplicator", 
        replicator, names);
    wrapper.setService(true); 
    cell.addPart(wrapper); 
    
    // Pass names to CellReplicator
    replicator.setCorePartNames(names);
}
protected WorkerWrapper createCoreWorkerWrapper(
        String name, Object worker, Vector names) {
        
    WorkerWrapper wrapper = new WorkerWrapperStd();
    wrapper.setWorker(worker);
    wrapper.setName(name);
    wrapper.setCore(true);
    wrapper.setHidden(true);
    
    names.addElement(name);
    
    return wrapper;
}
//--- Std ---------
private static void print(String text) {
    System.out.println("CellCreator" + text);
}

} // End class