package org.jcon.core;

/**
* This interface has a worker in a System Tree. It's
* really just a wrapper for an Object instance with
* various optional interfaces. Since it's a wrapper, the
* wrapped instance provides most of the behavior, leaving
* this interface very simple. When we say "worker" we
* are referring to the instance, not this inteface.
* <p>
* Note that even though this interface is simple, its use
* is powerful due to extending Part. This allows it
* to be used in wonderous ways by the core parts.
* <p>
* The worker is usually a leaf part, with the exception
* of companion parts associated with containers. A worker
* part performs work for the system by collaborating with
* other parts.
* <p>
* The responsibilities of a worker start with its designer.
* It MUST be designed for high reuse, usually with its
* coworkers in mind. Core worker parts are heavily reused,
* and so must be meticulously evolved to be do well in
* millions of containers. Domain worker parts are less
* heavily reused, but have perhaps the greater burden of
* providing domain specific behavior in a reusable, 
* reliable manner with sufficient speed.
*
* @author Jack Harich
*/
public interface WorkerWrapper extends Part {


/**
* Sets the worker instance. This is required.
*/
public void setWorker(Object instance);

/**
* Returns the worker instance.
*/
public Object getWorker();



} // End interface