package org.jcon.core;

/**
* A Part may optionally implement this interface to 
* indicate it can be started, and will perform some sort
* of state or behavior change after being started.
* <p>
* Examples are Containers and those Parts that are
* started in a root container's Primordial Invocations.
*
* @author Jack Harich
*/
public interface StartablePart {

/**
* The Part should start doing whatever it wants. If a 
* leaf part, it can assume all other parts in its
* container and above have been initialized.
*/
public void startPart();


} // End interface

/**

import org.jcon.core.StartablePart;

//----------- StartablePart Implementation ---------------
public void startPart() {

}

*/