package org.jcon.core;

import java.util.Enumeration;

/**
* This interface defines the non-mutator services we wish
* to expose for a Cell. This preserves core encapsulation.
* <p>
* Note that the setCell(Cell) method should not be used by
* non-core workers.
* <p>
* TODO - This is modeled after BasketServices. It has only
* a few representative methods. Add many more later.
*
* @author Jack Harich
*/
public interface CellServices extends 
                    Part, Replicable, CellUser {

/**
* Returns the named part or throws an IllegalStateException
* if not found. Can find "local" or "service" parts. If
* the part is not found in the cell, an upward
* search is made until the root cell is encountered.
* These are the cases: 
* <p> <p>
* 1. The part is found in the cell and returned. 
* Note it may be a local or service part.
* <p> <p>
* 2. The part is never found, so the exception is thrown.
* <p> <p>
* 3. The part is found upwardly, is a service part and
* is returned.
* <p> <p>
* 4. The part is found upwardly but is not a service part,
* and so the exception is thrown.
* <p>
* TODO - If the partName contains slashes, we look
* downward for it in a standard file path manner.
*/
public Part findPart(String partName);

/**
* Returns the worker instance for the partName, finding it
* in a manner similar to findPart(partName). The partName
* must be a worker, not a cell. 
*/
public Object findWorker(String partName);

/**
* Returns the named part in the cell or null if not
* found. Plese note this searches only the cell and
* may return null. 
*/
public Part getPart(String partName);

/**
* Returns the worker instance for the partName, getting it
* in a manner similar to getPart(partName). The partName
* must be a worker, not a cell. 
*/
public Object getWorker(String partName);

/**
* Returns an Enumeration of the parts in the cell. 
*/
public Enumeration getParts();


} // End interface