package org.jcon.core;

/**
* This interface is responsible for creating primordial
* cells, such is root cells. This is tricky. Here's how 
* it's done.
* <p>
* A system starter class instantiates a CellCreator, then
* calls createPrimordialCell(). This returns an empty
* cell ready for use as a root cell, such as by starting
* it. Under the covers the CellCreator creates a Cell, 
* creats and adds core parts to it, and then adds itself 
* to it. This and the CellReplicator is pretty simple, but
* took awhile to figure out. (2 years)
* <p>
* TODO - Later this will be configurable.
*
* @author Jack Harich
*/
public interface CellCreator {

/* These are for possible later use
public void setMarker(Object marker);
public void setParamStore(ParamStore paramStore);
*/

/**
* Creates and returns a ready-to-use new cell with no
* parent cell. The cell has all the necessary core parts,
* but no domain parts. Its state is uninitialized. (States 
* are uninitialized, started, more?)
* <p>
* The client is responsibile for setting the part name of
* the newly created cell, such as "Root".
*
* @return  a cell that can be used for replication to
*          construct an entire system tree.
*/
public Cell createPrimordialCell();

} // End interface