package org.jcon.ba.tree;

import org.jcon.ba.system.router.EventListenerProxy;
import org.jcon.ba.system.router.EventRouter;
import org.jcon.util.GenLib;
import java.lang.reflect.Method;

/**
 * A straightforward ItemTreeListener proxy. Note the use
 * of reflection, which should be avoided. This may evolve.
 *
 * @author Jack Harich
 */
public class ItemTreeListenerProxy extends
    EventListenerProxy implements ItemTreeListener {

//---------- Abstract Implementation ---------------------
public void addToSource(Object source) {
    try {
        // Create method
        Class[] argTypes = { ItemTreeListener.class };
        Method method = source.getClass().getMethod(
            "addItemTreeListener", argTypes );
        // Invoke method
        Object[] argValues = { this };
        method.invoke(source, argValues);

    } catch(Exception ex) {
        GenLib.exception("ItemTreeListenerProxy.addToSource()",
            "Failure with source " + source.getClass().getName(), ex);
    }
}
public void removeFromSource(Object source) {
    try {
        // Create method
        Class[] argTypes = { ItemTreeListener.class };
        Method method = source.getClass().getMethod(
            "removeItemTreeListener", argTypes );
        // Invoke method
        Object[] argValues = { this };
        method.invoke(source, argValues);

    } catch(Exception ex) {
        GenLib.exception("ItemTreeListenerProxy.removeFromSource()",
            "Failure with source " + source.getClass().getName(), ex);
    }
}
public void notifyListener(Object objectListener) {
    // interface has just 1 method
    ((ItemTreeListener)objectListener).
        itemTreeClosed((ItemTreeEvent)event);
}
//---------- ItemTreeListener Implementation --------------
public void itemTreeClosed(ItemTreeEvent evt) {
    this.event = evt;
    eventRouter.multicast(this);
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("ClassName" + text);
}

} // End class
