package org.jcon.ba.tree;

import org.jcon.ba.system.Item;
import java.util.EventObject;
import java.util.Vector;

/**
 * An item Tree event.
 *
 * @author Jack Harich
 */
public class ItemTreeEvent extends EventObject {

//---------- Private Fields ------------------------------
private Item    rootItem;
private boolean isBATree = false;
private Object  groupID;
private boolean mutable = false;

//---------- Initialization ------------------------------
public ItemTreeEvent(Item rootItem) {
    super("");
    this.rootItem = rootItem;
}
//---------- Properties ----------------------------------
public Item getRootItem() {
    return rootItem;
}
//----- isBATree
public void setBATree(boolean isBATree) {
    if (mutable) this.isBATree = isBATree;
}
/**
 * If true then the BA tree itself is involved. Due to
 * recursiveness the BA behaves differently when editing
 * itself.
 */
public boolean isBATree() {
    return isBATree;
}
//----- groupID
public void setGroupID(Object groupID) {
    if (mutable) this.groupID = groupID;
}
public Object getGroupID() {
    return groupID;
}
//---------- Public Methods ------------------------------
/**
 * The event creator should call this method after setting
 * event properties. After this method is called all setter
 * methods will have no effect, ie the instance has become
 * immutable.
 */
public void makeImmutable() {
    mutable = false;
}
/**
 * Sends this event to all the ItemTreeListeners in the
 * Vector. It first makes a copy of the Vector while
 * locking the source, thus guarenteeing that all listeners
 * will be notified.
 */
public void notifyListeners(Vector listeners, Object source) {
    Vector list;
    synchronized(source) {
        list = (Vector)listeners.clone();
    }
    for (int i = 0; i < list.size(); i++) {
        ItemTreeListener listener =
            (ItemTreeListener)list.elementAt(i);

        listener.itemTreeClosed(this);
    }
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("ClassName" + text);
}

} // End class
