package org.jcon.ba.system.router;

/**
 * The interface for an EventRouter listener. More events
 * such as listnerAdded(), etc may be added.
 *
 * Later we may need another event:
 * - sendingEvent(source, event, listener) for monitor
 * Since this degrades performance it's a separate event.
 *
 * @author Jack Harich
 */
public interface EventRouterListener {


/**
 * This event occurs before an event is multicast. This
 * is useful if a class must prepare for a multicast, such
 * as a Module that needs to start its items.
 */
public void beforeEventRouterMulticast(EventRouterEvent evt);


} // End interface
