package org.jcon.ba.system.router;

import org.jcon.ba.system.Basket;
import org.jcon.ba.system.BasketServices;
import org.jcon.ba.system.BeanPriv;
import org.jcon.util.GenLib;

/**
 * A BeanPriv wrapper for an EventRouter. This
 * class is used to provide event services for module items.
 *
 * @author Jack Harich
 */
public class EventRouterBIP implements BeanPriv {

//---------- Private Fields ------------------------------
private EventRouter    myRouter = new EventRouter();
private BasketServices myServices; // *** NOT USED

//---------- BeanPriv Implementation ---------------------
public void setBasketServices(BasketServices services) {
    myServices = services;
}
//---------- Public Methods ------------------------------
/**
 * The router will instantiate the proxyClassName
 * and use the proxy to add a listener to the source.
 * The source must be a bean instance, not a module.
 * This accomplishes - The router is now listening to the
 * source for the event. proxyClassName must be
 * an EventListenerProxy subclass.
 * *** add unprovide() later ***
 */
public void provideListener(String proxyClassName,
                    Object source) {
    EventListenerProxy proxy = (EventListenerProxy)
        GenLib.createInstance(proxyClassName);
    proxy.addToSource(source);
    proxy.setEventRouter(myRouter);
}
/**
 * This EventRouter will get the EventRouter in the
 * basket, and add itself as a listener for
 * eventClassName in that basket's EventRouter. The
 * basket must have an item named "eventRouter" which is an
 * EventRouter. Thus a system using the EventRouter will
 * have EventRouter items in most or all of its baskets.
 *
 * NOTE - Supporting any event instead of Messages has
 * turned out to be incredibly awkward. This feature will
 * probably be removed in the future. **********
 *
 * *** will add removeBasketSource() ***
 */
public void addBasketSource(String eventClassName,
                    Basket basket) {
    //print(" - before got router");
    // Assume router is a Bean - Encapsulation violation ***
    EventRouterBIP router = (EventRouterBIP)basket
        .getLiveItem("eventRouter").getBeanInstance();
    //print(" - after got router");
    router.addListener(eventClassName, myRouter);
}
/**
 * Adds the  listener to the collection of listeners
 * that will receive proper notification when the
 * eventClassName occurs. The @param listener must implement
 * the appropriate event listener interface or an EventRouter.
 */
public void addListener(String eventClassName, Object listener) {
    //print(".addListener() - eventClassName = " + eventClassName);
    myRouter.addListener(eventClassName, listener);
}
public void removeListener(String eventClassName, Object listener) {
    myRouter.removeListener(eventClassName, listener);
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("EventRouterBIP" + text);
}

} // End class
