package org.jcon.ba.system;

import org.jcon.param.*;
import org.jcon.util.BenchMark;
import org.jcon.util.service.ContainerServices;

/**
 * A ParamSupplier for Items needing Params.
 *
 * @author Jack Harich
 */
public class ItemParamSupplier implements ParamSupplier {

//---------- Private Fields ------------------------------
private ParamStore        paramStore;
private ParamAccessor     accessor;
private ContainerServices containerServices;

//---------- Initialization ------------------------------
public ItemParamSupplier(ParamStore paramStore,
        ParamAccessor accessor, ContainerServices containerServices) {

    this.paramStore = paramStore;
    this.accessor = accessor;
    this.containerServices = containerServices;
}
//---------- ParamSupplier Implementation ----------------
public void supplyParam(ParamDriven paramDriven) {

    // Get Param
    String resource = accessor.getResourceName();
    //print(".supplyParam() - Before readParam() " +
    //    BenchMark.getTimePoint(0) + " - " + resource);
    Param param = paramStore.readParam(accessor);
    //print(".supplyParam() - Time to read = " +
    //    BenchMark.getTimeElapsed(0));
    
    // Build Param
    param = ItemSystem.buildParam(param, containerServices);

    // Set 2 way link
    param.setParamDriven(paramDriven);
    paramDriven.setParam(param);

}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("ItemParamSupplier" + text);
}

} // End class
